/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.debug;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.debug.Debug;

public class DebugTest {
    @Test
    public void testAbbreviatedName() {
        Assert.assertEquals((Object)"ju.List", (Object)Debug.abbreviatedName(List.class));
    }

    @Test
    public void testMemorableNumber() {
        Assert.assertEquals((Object)"badodyre", (Object)Debug.toMemorableString((long)56385664L));
    }

    @Test
    public void testObjectId() {
        HashMap m = new HashMap();
        Assert.assertEquals((Object)(Debug.abbreviatedName(m.getClass()) + "@" + Debug.toMemorableString((long)System.identityHashCode(m))), (Object)Debug.objectId(m));
    }

    @Test
    public void testShortNameWithInnerClass() {
        Assert.assertEquals((Object)"Map$Entry", (Object)Debug.shortName(Map.Entry.class));
    }

    @Test
    public void testShortNameInDefaultPackage() throws Exception {
        Assert.assertEquals((Object)"NaughtyClassInDefaultPackage", (Object)Debug.shortName(Class.forName("NaughtyClassInDefaultPackage")));
    }

    @Test
    public void testAbbreviatedNameInDefaultPackage() throws Exception {
        Assert.assertEquals((Object)"NaughtyClassInDefaultPackage", (Object)Debug.abbreviatedName(Class.forName("NaughtyClassInDefaultPackage")));
    }
}

