/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.apps.client.home;

import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.apps.api.AppsPersistenceAPI;
import org.uberfire.ext.apps.api.Directory;
import org.uberfire.ext.apps.api.DirectoryBreadCrumb;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.mvp.ParameterizedCommand;

@ApplicationScoped
@WorkbenchScreen(identifier="AppsHomePresenter")
public class AppsHomePresenter {
    @Inject
    private View view;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<AppsPersistenceAPI> appService;
    private Directory currentDirectory;
    private Directory root;

    @PostConstruct
    public void init() {
    }

    @OnOpen
    public void loadContent() {
        this.view.clear();
        ((AppsPersistenceAPI)this.appService.call((RemoteCallback)new RemoteCallback<Directory>(){

            public void callback(Directory root_) {
                AppsHomePresenter.this.root = root_;
                AppsHomePresenter.this.currentDirectory = root_;
                AppsHomePresenter.this.setupView();
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                return false;
            }
        })).getRootDirectory();
    }

    private ParameterizedCommand<String> generateBreadCrumbViewCommand() {
        return new ParameterizedCommand<String>(){

            public void execute(String parameter) {
                AppsHomePresenter.this.currentDirectory = AppsHomePresenter.this.searchForDirectory(parameter, AppsHomePresenter.this.root);
                AppsHomePresenter.this.setupView();
            }
        };
    }

    private Directory searchForDirectory(String parameter, Directory candidate) {
        Directory directory;
        if (candidate.getURI().equalsIgnoreCase(parameter)) {
            return candidate;
        }
        Directory target = null;
        Iterator i$ = candidate.getChildsDirectories().iterator();
        while (i$.hasNext() && (target = this.searchForDirectory(parameter, directory = (Directory)i$.next())) == null) {
        }
        return target;
    }

    private ParameterizedCommand<String> generateDeleteDirectoryViewCommand() {
        return new ParameterizedCommand<String>(){

            public void execute(final String uri) {
                ((AppsPersistenceAPI)AppsHomePresenter.this.appService.call((RemoteCallback)new RemoteCallback<Boolean>(){

                    public void callback(Boolean deleted) {
                        AppsHomePresenter.this.currentDirectory.removeChildDirectoryByURI(uri);
                        AppsHomePresenter.this.view.clear();
                        AppsHomePresenter.this.view.setupChildsDirectories(AppsHomePresenter.this.currentDirectory.getChildsDirectories(), (ParameterizedCommand<String>)AppsHomePresenter.this.generateDirectoryViewCommand(), (ParameterizedCommand<String>)AppsHomePresenter.this.generateDeleteDirectoryViewCommand());
                        AppsHomePresenter.this.view.setupChildComponents(AppsHomePresenter.this.currentDirectory.getChildComponents(), (ParameterizedCommand<String>)AppsHomePresenter.this.generateComponentViewCommand());
                        AppsHomePresenter.this.view.setupAddDir((ParameterizedCommand<String>)AppsHomePresenter.this.generateAddDirCommand(), AppsHomePresenter.this.currentDirectory);
                    }
                }, (ErrorCallback)new ErrorCallback<Object>(){

                    public boolean error(Object o, Throwable throwable) {
                        return false;
                    }
                })).deleteDirectory(uri);
            }
        };
    }

    private ParameterizedCommand<String> generateDirectoryViewCommand() {
        return new ParameterizedCommand<String>(){

            public void execute(String parameter) {
                for (Directory candidate : AppsHomePresenter.this.currentDirectory.getChildsDirectories()) {
                    if (!candidate.getURI().equalsIgnoreCase(parameter)) continue;
                    AppsHomePresenter.this.currentDirectory = candidate;
                    AppsHomePresenter.this.setupView();
                }
            }
        };
    }

    private void setupView() {
        this.view.clear();
        this.view.setupBreadCrumbs(DirectoryBreadCrumb.getBreadCrumbs((Directory)this.currentDirectory), this.generateBreadCrumbViewCommand());
        this.view.setupChildsDirectories(this.currentDirectory.getChildsDirectories(), this.generateDirectoryViewCommand(), this.generateDeleteDirectoryViewCommand());
        this.view.setupChildComponents(this.currentDirectory.getChildComponents(), this.generateComponentViewCommand());
        this.view.setupAddDir(this.generateAddDirCommand(), this.currentDirectory);
    }

    private ParameterizedCommand<String> generateComponentViewCommand() {
        return new ParameterizedCommand<String>(){

            public void execute(String parameter) {
                AppsHomePresenter.this.placeManager.goTo(parameter);
            }
        };
    }

    private ParameterizedCommand<String> generateAddDirCommand() {
        return new ParameterizedCommand<String>(){

            public void execute(String directoryName) {
                ((AppsPersistenceAPI)AppsHomePresenter.this.appService.call((RemoteCallback)new RemoteCallback<Directory>(){

                    public void callback(Directory newDir) {
                        AppsHomePresenter.this.currentDirectory.addChildDirectory(newDir);
                        AppsHomePresenter.this.view.clear();
                        AppsHomePresenter.this.view.setupChildsDirectories(AppsHomePresenter.this.currentDirectory.getChildsDirectories(), (ParameterizedCommand<String>)AppsHomePresenter.this.generateDirectoryViewCommand(), (ParameterizedCommand<String>)AppsHomePresenter.this.generateDeleteDirectoryViewCommand());
                        AppsHomePresenter.this.view.setupChildComponents(AppsHomePresenter.this.currentDirectory.getChildComponents(), (ParameterizedCommand<String>)AppsHomePresenter.this.generateComponentViewCommand());
                        AppsHomePresenter.this.view.setupAddDir((ParameterizedCommand<String>)AppsHomePresenter.this.generateAddDirCommand(), AppsHomePresenter.this.currentDirectory);
                    }
                }, (ErrorCallback)new ErrorCallback<Object>(){

                    public boolean error(Object o, Throwable throwable) {
                        return false;
                    }
                })).createDirectory(AppsHomePresenter.this.currentDirectory, directoryName);
            }
        };
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Apps Home";
    }

    @WorkbenchPartView
    public UberView<AppsHomePresenter> getView() {
        return this.view;
    }

    public static interface View
    extends UberView<AppsHomePresenter> {
        public void setupBreadCrumbs(List<DirectoryBreadCrumb> var1, ParameterizedCommand<String> var2);

        public void setupAddDir(ParameterizedCommand<String> var1, Directory var2);

        public void setupChildsDirectories(List<Directory> var1, ParameterizedCommand<String> var2, ParameterizedCommand<String> var3);

        public void clear();

        public void setupChildComponents(List<String> var1, ParameterizedCommand<String> var2);
    }
}

