/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.repositories;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationFactory;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.repositories.Location;
import org.uberfire.backend.server.repositories.RepositoryFactory;

@Service
@ApplicationScoped
public class RepositoryServiceImpl
implements RepositoryService {
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private RepositoryFactory repositoryFactory;
    private Map<String, Repository> configuredRepositories = new HashMap<String, Repository>();

    @PostConstruct
    public void loadRepositories() {
        List repoConfigs = this.configurationService.getConfiguration(ConfigType.REPOSITORY);
        if (repoConfigs != null && !repoConfigs.isEmpty()) {
            for (ConfigGroup config : repoConfigs) {
                Repository repository = this.repositoryFactory.newRepository(config);
                this.configuredRepositories.put(repository.getAlias(), repository);
            }
        }
    }

    public Repository getRepository(String alias) {
        return this.configuredRepositories.get(alias);
    }

    public Collection<Repository> getRepositories() {
        return Collections.unmodifiableCollection(this.configuredRepositories.values());
    }

    public void createRepository(String scheme, String alias, String username, String password) {
        ConfigGroup repositoryConfig = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, alias, "");
        repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("scheme", scheme));
        repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("username", username));
        repositoryConfig.addConfigItem(this.configurationFactory.newSecuredConfigItem("password", password));
        repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("location", Location.LOCAL.name()));
        repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("init", Boolean.TRUE.booleanValue()));
        this.addRepository(repositoryConfig);
    }

    public void cloneRepository(String scheme, String alias, String origin, String username, String password) {
        ConfigGroup repositoryConfig = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, alias, "");
        repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("scheme", scheme));
        repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("username", username));
        repositoryConfig.addConfigItem(this.configurationFactory.newSecuredConfigItem("password", password));
        repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("location", Location.REMOTE.name()));
        repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("origin", origin));
        this.addRepository(repositoryConfig);
    }

    private void addRepository(ConfigGroup repositoryConfig) {
        Repository repository = this.repositoryFactory.newRepository(repositoryConfig);
        this.configurationService.addConfiguration(repositoryConfig);
        this.configuredRepositories.put(repository.getAlias(), repository);
    }
}

