/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.commons.io.FileSystemType;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.FileSystemAlreadyExistsException;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigGroupMarshaller;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.config.SystemRepositoryChangedEvent;
import org.uberfire.security.Identity;

@ApplicationScoped
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final String LAST_MODIFIED_MARKER_FILE = ".lastmodified";
    private static final String MONITOR_DISABLED = "org.kie.sys.repo.monitor.disabled";
    private static final String MONITOR_CHECK_INTERVAL = "org.kie.sys.repo.monitor.interval";
    private static final String INVALID_FILENAME_CHARS = "[\\,/,:,*,?,\",<,>,|]";
    @Inject
    @Named(value="system")
    private Repository systemRepository;
    @Inject
    private ConfigGroupMarshaller marshaller;
    @Inject
    private Identity identity;
    private final Map<ConfigType, List<ConfigGroup>> configuration = new ConcurrentHashMap<ConfigType, List<ConfigGroup>>();
    private long localLastModifiedValue = -1L;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Event<SystemRepositoryChangedEvent> changedEvent;
    private ExecutorService executorService;

    @PostConstruct
    public void setup() {
        try {
            this.ioService.newFileSystem(URI.create(this.systemRepository.getUri()), this.systemRepository.getEnvironment(), (FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE);
            this.updateLastModified();
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        if (System.getProperty(MONITOR_DISABLED) == null) {
            this.executorService = Executors.newSingleThreadExecutor();
            this.executorService.execute(new CheckConfigurationUpdates());
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public List<ConfigGroup> getConfiguration(final ConfigType type) {
        if (this.configuration.containsKey(type)) {
            return this.configuration.get(type);
        }
        ArrayList<ConfigGroup> configGroups = new ArrayList<ConfigGroup>();
        DirectoryStream foundConfigs = this.ioService.newDirectoryStream(this.ioService.get(this.systemRepository.getUri(), new String[0]), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && entry.getFileName().toString().endsWith(type.getExt());
            }
        });
        Iterator it = foundConfigs.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String content = this.ioService.readAllString((Path)it.next());
                ConfigGroup configGroup = this.marshaller.unmarshall(content);
                configGroups.add(configGroup);
            }
            this.configuration.put(type, configGroups);
        }
        return configGroups;
    }

    public boolean addConfiguration(ConfigGroup configGroup) {
        String filename = configGroup.getName().replaceAll(INVALID_FILENAME_CHARS, "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        if (this.ioService.exists(filePath)) {
            return true;
        }
        CommentedOption commentedOption = new CommentedOption(this.getIdentityName(), "Created config " + filePath.getFileName());
        this.ioService.write(filePath, this.marshaller.marshall(configGroup), new OpenOption[]{commentedOption});
        this.configuration.remove(configGroup.getType());
        this.updateLastModified();
        return true;
    }

    public boolean updateConfiguration(ConfigGroup configGroup) {
        String filename = configGroup.getName().replaceAll(INVALID_FILENAME_CHARS, "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        CommentedOption commentedOption = new CommentedOption(this.getIdentityName(), "Updated config " + filePath.getFileName());
        this.ioService.write(filePath, this.marshaller.marshall(configGroup), new OpenOption[]{commentedOption});
        this.configuration.remove(configGroup.getType());
        this.updateLastModified();
        return true;
    }

    public boolean removeConfiguration(ConfigGroup configGroup) {
        this.configuration.remove(configGroup.getType());
        String filename = configGroup.getName().replaceAll(INVALID_FILENAME_CHARS, "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        if (!this.ioService.exists(filePath)) {
            return true;
        }
        boolean result = this.ioService.deleteIfExists(filePath);
        if (result) {
            this.updateLastModified();
        }
        return result;
    }

    protected String getIdentityName() {
        try {
            return this.identity.getName();
        }
        catch (ContextNotActiveException e) {
            return "unknown";
        }
    }

    protected long getLastModified() {
        Path lastModifiedPath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(LAST_MODIFIED_MARKER_FILE);
        return this.ioService.getLastModifiedTime(lastModifiedPath).toMillis();
    }

    protected void updateLastModified() {
        Path lastModifiedPath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(LAST_MODIFIED_MARKER_FILE);
        CommentedOption commentedOption = new CommentedOption("system", "system repo updated");
        this.ioService.write(lastModifiedPath, new Date().toString().getBytes(), new OpenOption[]{commentedOption});
        this.localLastModifiedValue = this.getLastModified();
    }

    private class CheckConfigurationUpdates
    implements Runnable {
        private boolean active = true;

        private CheckConfigurationUpdates() {
        }

        @Override
        public void run() {
            while (this.active) {
                try {
                    long currentValue = ConfigurationServiceImpl.this.getLastModified();
                    if (currentValue > ConfigurationServiceImpl.this.localLastModifiedValue) {
                        ConfigurationServiceImpl.this.localLastModifiedValue = currentValue;
                        ConfigurationServiceImpl.this.configuration.remove(ConfigType.DEPLOYMENT);
                        ConfigurationServiceImpl.this.changedEvent.fire((Object)new SystemRepositoryChangedEvent());
                    }
                    Thread.sleep(Long.parseLong(System.getProperty(ConfigurationServiceImpl.MONITOR_CHECK_INTERVAL, "2000")));
                }
                catch (Exception exception) {}
            }
        }

        public void deactivate() {
            this.active = false;
        }
    }
}

