/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.version.VersionAttributeView;
import org.kie.commons.java.nio.base.version.VersionRecord;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.ocpsoft.prettytime.PrettyTime;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.navigator.DataContent;
import org.uberfire.navigator.FileNavigatorService;
import org.uberfire.navigator.NavigatorContent;

@Service
@ApplicationScoped
public class FileNavigatorServiceImpl
implements FileNavigatorService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Paths paths;
    @Inject
    private RepositoryService repositoryService;
    private final PrettyTime p = new PrettyTime();

    public NavigatorContent listContent(org.uberfire.backend.vfs.Path _path) {
        ArrayList<DataContent> result = new ArrayList<DataContent>();
        ArrayList<org.uberfire.backend.vfs.Path> breadcrumbs = new ArrayList<org.uberfire.backend.vfs.Path>();
        Path path = this.paths.convert(_path);
        DirectoryStream stream = this.ioService.newDirectoryStream(path);
        for (Path activePath : stream) {
            VersionAttributeView versionAttributeView = (VersionAttributeView)this.ioService.getFileAttributeView(activePath, VersionAttributeView.class);
            int index = versionAttributeView.readAttributes().history().records().size() - 1;
            String authorEmail = ((VersionRecord)versionAttributeView.readAttributes().history().records().get(index)).email();
            String author = ((VersionRecord)versionAttributeView.readAttributes().history().records().get(index)).author();
            String comment = ((VersionRecord)versionAttributeView.readAttributes().history().records().get(index)).comment();
            String time = this.p.format(new Date(Files.getLastModifiedTime((Path)activePath, (LinkOption[])new LinkOption[0]).toMillis()));
            result.add(new DataContent(Files.isDirectory((Path)activePath, (LinkOption[])new LinkOption[0]), comment, author, authorEmail, time, this.paths.convert(activePath)));
        }
        Collections.sort(result, new Comparator<DataContent>(){

            @Override
            public int compare(DataContent dataContent, DataContent dataContent2) {
                int fileCompare = dataContent.getPath().getFileName().toLowerCase().compareTo(dataContent2.getPath().getFileName().toLowerCase());
                if (dataContent.isDirectory() && dataContent2.isDirectory()) {
                    return fileCompare;
                }
                if (dataContent.isDirectory()) {
                    return -1;
                }
                if (dataContent2.isDirectory()) {
                    return 1;
                }
                return fileCompare;
            }
        });
        if (!path.equals(path.getRoot())) {
            while (!path.getParent().equals(path.getRoot())) {
                path = path.getParent();
                breadcrumbs.add(this.paths.convert(path));
            }
            Collections.reverse(breadcrumbs);
        }
        org.uberfire.backend.vfs.Path root = this.paths.convert(path.getRoot());
        return new NavigatorContent(this.repositoryService.getRepository(root).getAlias(), root, breadcrumbs, result);
    }

    public List<Repository> listRepositories() {
        return new ArrayList<Repository>(this.repositoryService.getRepositories());
    }
}

