/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.repositories;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.commons.validation.Preconditions;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.PasswordService;
import org.uberfire.backend.server.repositories.RepositoryFactory;
import org.uberfire.backend.server.repositories.RepositoryFactoryHelper;

@ApplicationScoped
public class RepositoryFactoryImpl
implements RepositoryFactory {
    @Inject
    private PasswordService secureService;
    @Inject
    @Any
    private Instance<RepositoryFactoryHelper> helpers;

    public Repository newRepository(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        Repository repository = null;
        for (RepositoryFactoryHelper helper : this.helpers) {
            if (!helper.accept(repoConfig)) continue;
            repository = helper.newRepository(repoConfig);
            break;
        }
        if (repository == null) {
            throw new IllegalArgumentException("Unrecognized scheme '" + (String)schemeConfigItem.getValue() + "'.");
        }
        ConfigItem roles = repoConfig.getConfigItem("security:roles");
        if (roles != null) {
            for (String role : (List)roles.getValue()) {
                repository.getRoles().add(role);
            }
        }
        return repository;
    }
}

