/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.exports;

import java.util.LinkedList;
import java.util.List;
import org.uberfire.ext.editor.commons.file.exports.PdfExportPreferences;

public final class PdfDocument {
    private final List<PdfEntry> entries = new LinkedList<PdfEntry>();
    private final PdfExportPreferences settings;

    public static PdfDocument create(PdfExportPreferences settings) {
        return new PdfDocument(settings);
    }

    private PdfDocument(PdfExportPreferences settings) {
        this.settings = settings;
    }

    public void addText(String text, int x, int y) {
        this.entries.add(new Text(text, x, y));
    }

    public void addImage(String urlData, String imgType, int x, int y, int width, int height) {
        this.entries.add(new Image(urlData, imgType, x, y, width, height));
    }

    public PdfExportPreferences getSettings() {
        return this.settings;
    }

    List<PdfEntry> getPdfEntries() {
        return this.entries;
    }

    static final class Image
    implements PdfEntry {
        private final String toDataURL;
        private final String imgType;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        private Image(String toDataURL, String imgType, int x, int y, int width, int height) {
            this.toDataURL = toDataURL;
            this.imgType = imgType;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public String getToDataURL() {
            return this.toDataURL;
        }

        public String getImgType() {
            return this.imgType;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    static final class Text
    implements PdfEntry {
        private final String text;
        private final int x;
        private final int y;

        private Text(String text, int x, int y) {
            this.text = text;
            this.x = x;
            this.y = y;
        }

        public String getText() {
            return this.text;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    static interface PdfEntry {
    }
}

