/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.definition.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinitionProvider;

public class ExperimentalFeatureDefRegistryImpl
implements ExperimentalFeatureDefRegistry {
    protected Map<String, ExperimentalFeatureDefinition> features = new HashMap<String, ExperimentalFeatureDefinition>();

    public void register(ExperimentalFeatureDefinitionProvider definitionProvider) {
        this.register(definitionProvider.getDefinition());
    }

    public void register(ExperimentalFeatureDefinition featureDefinition) {
        this.features.put(featureDefinition.getId(), featureDefinition);
    }

    @Override
    public ExperimentalFeatureDefinition getFeatureById(String definitionId) {
        return this.features.get(definitionId);
    }

    @Override
    public Collection<ExperimentalFeatureDefinition> getAllFeatures() {
        return Collections.unmodifiableCollection(this.features.values());
    }

    @Override
    public Collection<ExperimentalFeatureDefinition> getGlobalFeatures() {
        return Collections.unmodifiableCollection(this.features.values().stream().filter(ExperimentalFeatureDefinition::isGlobal).collect(Collectors.toList()));
    }

    @Override
    public Collection<ExperimentalFeatureDefinition> getUserFeatures() {
        return Collections.unmodifiableCollection(this.features.values().stream().filter(feature -> !feature.isGlobal()).collect(Collectors.toList()));
    }
}

