/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.editor.group.feature;

import elemental2.dom.HTMLElement;
import java.util.Comparator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.experimental.client.editor.group.feature.ExperimentalFeatureEditorView;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.editor.EditableExperimentalFeature;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class ExperimentalFeatureEditor
implements ExperimentalFeatureEditorView.Presenter,
IsElement,
Comparable<ExperimentalFeatureEditor> {
    private static Comparator<String> comparator = Comparator.nullsFirst(String::compareTo);
    private ExperimentalFeatureDefRegistry registry;
    private TranslationService translationService;
    private ExperimentalFeatureEditorView view;
    private EditableExperimentalFeature feature;
    private ParameterizedCommand<EditableExperimentalFeature> onChange;
    private String name;

    @Inject
    public ExperimentalFeatureEditor(ExperimentalFeatureDefRegistry registry, TranslationService translationService, ExperimentalFeatureEditorView view) {
        this.registry = registry;
        this.translationService = translationService;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void render(EditableExperimentalFeature feature, ParameterizedCommand<EditableExperimentalFeature> onChange) {
        PortablePreconditions.checkNotNull((String)"feature", (Object)feature);
        PortablePreconditions.checkNotNull((String)"onChange", onChange);
        this.feature = feature;
        this.onChange = onChange;
        ExperimentalFeatureDefinition definition = this.registry.getFeatureById(feature.getFeatureId());
        PortablePreconditions.checkNotNull((String)"definition", (Object)definition);
        this.name = this.getTranslation(definition.getNameKey(), definition.getId());
        String description = this.getTranslation(definition.getDescriptionKey(), null);
        this.view.render(this.name, description, feature.isEnabled());
    }

    private String getTranslation(String key, String defaultValue) {
        String result = this.translationService.getTranslation(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public EditableExperimentalFeature getFeature() {
        return this.feature;
    }

    @Override
    public void notifyChange(boolean newEnabledValue) {
        if (newEnabledValue != this.feature.isEnabled()) {
            this.feature.setEnabled(newEnabledValue);
            this.onChange.execute((Object)this.feature);
        }
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public int compareTo(ExperimentalFeatureEditor other) {
        return comparator.compare(this.getName(), other.getName());
    }

    public boolean isEnabled() {
        return this.feature.isEnabled();
    }

    public void enable() {
        this.view.setEnabled(!this.feature.isEnabled());
    }
}

