/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.editor.group.feature;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.user.client.Event;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLLabelElement;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.gwtbootstrap3.extras.toggleswitch.client.ui.ToggleSwitch;
import org.gwtbootstrap3.extras.toggleswitch.client.ui.base.constants.SizeType;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.experimental.client.editor.group.feature.ExperimentalFeatureEditorView;

@Templated
public class ExperimentalFeatureEditorViewImpl
implements ExperimentalFeatureEditorView,
IsElement {
    private ExperimentalFeatureEditorView.Presenter presenter;
    @Inject
    @DataField
    private HTMLLabelElement name;
    @DataField
    @Inject
    private HTMLLabelElement description;
    @Inject
    @DataField
    private ToggleSwitch enabled;

    public void init(ExperimentalFeatureEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void init() {
        this.enabled.setSize(SizeType.MINI);
    }

    @Override
    public void render(String name, String description, boolean enabled) {
        this.name.textContent = name;
        if (description != null) {
            this.description.textContent = description;
        }
        this.enabled.setValue(Boolean.valueOf(enabled));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled.setValue(Boolean.valueOf(enabled), true);
    }

    private void maybeAddTitle(HTMLElement element) {
        if (element.offsetWidth < element.scrollWidth && element.title.isEmpty()) {
            element.title = element.textContent;
        }
    }

    @SinkNative(value=16)
    @EventHandler(value={"name"})
    public void onLoadName(Event event) {
        this.maybeAddTitle((HTMLElement)this.name);
    }

    @SinkNative(value=16)
    @EventHandler(value={"description"})
    public void onLoadDescription(Event event) {
        this.maybeAddTitle((HTMLElement)this.description);
    }

    @EventHandler(value={"enabled"})
    public void onToggleChange(ChangeEvent event) {
        this.presenter.notifyChange(this.enabled.getValue());
    }
}

