/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.appformer.maven.integration.Aether;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.FixNotMavenizedArtifactInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class M2ServletContextListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(M2ServletContextListener.class);
    private static final String FORCE_OFFLINE = "kie.maven.offline.force";
    static final String GROUP_ID = "groupId";
    static final String ARTIFACT_ID = "artifactId";
    static final String VERSION = "version";
    private static final String JAR_EXT = ".jar";
    private static final String WEB_INF_FOLDER = "WEB-INF";
    private static final String LIB_FOLDER = "lib";
    private static final String JAR_ARTIFACT = "jar";
    private static final String JARS_FOLDER = File.separator + "WEB-INF" + File.separator + "lib" + File.separator;
    private static final String MAVEN_META_INF = "META-INF" + File.separator + "maven";
    private final Path tempDir;
    private final FixNotMavenizedArtifactInfo fixNotMavenizedArtifact = new FixNotMavenizedArtifactInfo();

    public M2ServletContextListener() {
        Path tempDir = null;
        try {
            tempDir = Files.createTempDirectory("pom-extract", new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.tempDir = tempDir;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        if (Boolean.valueOf(System.getProperty(FORCE_OFFLINE, "false")).booleanValue()) {
            logger.info("M2ServletContextListener contextInitialized started");
            ServletContext ctx = servletContextEvent.getServletContext();
            String jarsPath = ctx.getRealPath(JARS_FOLDER);
            long startTime = System.nanoTime();
            int jarsDeployed = this.deployJarsFromWar(jarsPath);
            long endTime = System.nanoTime();
            long totalTime = TimeUnit.NANOSECONDS.toSeconds(endTime - startTime);
            logger.info("M2ServletContextListener contextInitialized deployed {} jars in {} sec ", (Object)jarsDeployed, (Object)totalTime);
        } else {
            logger.debug("M2ServletContextListener not executed, offline `{}` options set to false.", (Object)FORCE_OFFLINE);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    int deployJarsFromWar(String path) {
        int i = 0;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(Paths.get(path, new String[0]));){
            for (Path p : ds) {
                if (!p.toString().endsWith(JAR_EXT)) continue;
                this.deployJar(p.toAbsolutePath().toString());
                ++i;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return i;
    }

    GAV deployJar(String file) {
        GAV gav = new GAV();
        Properties props = this.readZipFile(file);
        if (!props.isEmpty()) {
            gav = new GAV(props.getProperty(GROUP_ID), props.getProperty(ARTIFACT_ID), props.getProperty(VERSION));
            this.deploy(gav, file);
        }
        return gav;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties readZipFile(String zipFilePath) {
        try {
            ZipEntry entry;
            ZipFile zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            do {
                if (!e.hasMoreElements()) return this.fixNotMavenizedArtifact.getProperties(zipFilePath);
            } while ((entry = e.nextElement()).isDirectory() || !entry.getName().startsWith(MAVEN_META_INF) || !entry.getName().endsWith("pom.properties"));
            try (BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));){
                Properties props = new Properties();
                props.load(bis);
                Properties properties = props;
                return properties;
            }
        }
        catch (IOException e2) {
            logger.error("IOError :{}", (Object)e2.getMessage(), (Object)e2);
        }
        return this.fixNotMavenizedArtifact.getProperties(zipFilePath);
    }

    public void deploy(GAV gav, String jarPath) {
        Artifact artifact = MavenRepository.getMavenRepository().resolveArtifact((AFReleaseId)new AFReleaseIdImpl(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()));
        if (artifact != null) {
            logger.info("Maven Artifact {} already exists in local Maven repository.", (Object)gav.toString());
            return;
        }
        logger.warn("Maven Artifact {} deployed from WEB-INF.", (Object)gav.toString());
        DefaultArtifact jarArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), JAR_ARTIFACT, gav.getVersion());
        File jarFile = new File(jarPath);
        jarArtifact = jarArtifact.setFile(jarFile);
        Artifact pom = null;
        try {
            ZipFile jarZipFile = new ZipFile(jarArtifact.getFile());
            boolean foundPom = false;
            Path target = null;
            Enumeration<? extends ZipEntry> entries = jarZipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith("pom.xml")) continue;
                foundPom = true;
                String jarFileName = jarArtifact.getFile().toPath().getFileName().toString();
                Path pomDir = Files.createDirectory(this.tempDir.resolve(jarFileName), new FileAttribute[0]);
                target = Files.createFile(pomDir.resolve(jarFileName.substring(0, jarFileName.length() - 4) + ".pom"), new FileAttribute[0]);
                InputStream stream = jarZipFile.getInputStream(entry);
                Files.copy(stream, target, StandardCopyOption.REPLACE_EXISTING);
                break;
            }
            if (!foundPom) {
                String pomFileName = jarFile.toPath().getFileName().toString().replace(JAR_EXT, ".pom");
                String result = this.fixNotMavenizedArtifact.buildPom(gav);
                target = Files.createFile(this.tempDir.resolve(pomFileName), new FileAttribute[0]);
                Files.write(target, result.getBytes(), new OpenOption[0]);
            }
            pom = new SubArtifact((Artifact)jarArtifact, null, "pom").setFile(target.toFile());
        }
        catch (Exception ex) {
            pom = null;
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            InstallRequest installRequest = new InstallRequest();
            installRequest.addArtifact((Artifact)jarArtifact);
            if (pom != null) {
                installRequest.addArtifact(pom);
            }
            Aether.getAether().getSystem().install(Aether.getAether().getSession(), installRequest);
        }
        catch (InstallationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

