/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.client.widgets;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.m2repo.client.widgets.ArtifactListPresenter;
import org.guvnor.m2repo.client.widgets.ArtifactListView;
import org.guvnor.m2repo.client.widgets.ColumnType;
import org.guvnor.m2repo.model.JarListPageRequest;
import org.guvnor.m2repo.model.JarListPageRow;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ArtifactListPresenterImpl
implements ArtifactListPresenter {
    static final boolean DEFAULT_ORDER_ASCENDING = true;
    private final ArtifactListView view;
    private final Caller<M2RepoService> m2RepoService;
    private final Event<NotificationEvent> notification;
    RefreshableAsyncDataProvider dataProvider;
    private boolean notify = true;

    @Inject
    public ArtifactListPresenterImpl(ArtifactListView view, Caller<M2RepoService> m2RepoService, Event<NotificationEvent> notification) {
        this.view = view;
        this.m2RepoService = m2RepoService;
        this.notification = notification;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.dataProvider = new RefreshableAsyncDataProvider(this.view, this.m2RepoService);
    }

    @Override
    public ArtifactListView getView() {
        return this.view;
    }

    @Override
    public void setup(ColumnType ... columns) {
        this.view.setup(columns);
    }

    @Override
    public void notifyOnRefresh(boolean notify) {
        this.notify = notify;
    }

    @Override
    public void refresh() {
        this.dataProvider.refresh();
        if (this.notify) {
            this.notification.fire((Object)new NotificationEvent(this.view.getRefreshNotificationMessage()));
        }
    }

    @Override
    public void search(String filter) {
        this.search(filter, null);
    }

    @Override
    public void search(String filter, List<String> fileFormats) {
        this.dataProvider.setFilter(filter);
        this.dataProvider.setFileFormats(fileFormats);
        if (this.dataProvider.getDataDisplays().isEmpty()) {
            this.dataProvider.addDataDisplay(this.view.getDisplay());
        } else {
            this.dataProvider.goToFirstPage();
        }
        if (this.notify) {
            this.notification.fire((Object)new NotificationEvent(this.view.getRefreshNotificationMessage()));
        }
    }

    @Override
    public void onOpenPom(String path) {
        ((M2RepoService)this.m2RepoService.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String response) {
                ArtifactListPresenterImpl.this.view.showPom(response);
            }
        })).getPomText(path);
    }

    static class RefreshableAsyncDataProvider
    extends AsyncDataProvider<JarListPageRow> {
        private final ArtifactListView view;
        private final Caller<M2RepoService> m2RepoService;
        private String filter;
        private List<String> fileFormats;

        protected RefreshableAsyncDataProvider(ArtifactListView view, Caller<M2RepoService> m2RepoService) {
            this.view = (ArtifactListView)PortablePreconditions.checkNotNull((String)"view", (Object)view);
            this.m2RepoService = (Caller)PortablePreconditions.checkNotNull((String)"m2RepoService", m2RepoService);
        }

        protected void setFilter(String filter) {
            this.filter = filter;
        }

        protected void setFileFormats(List<String> fileFormats) {
            this.fileFormats = fileFormats;
        }

        protected void goToFirstPage() {
            for (HasData display : this.getDataDisplays()) {
                boolean wasOnFirstPage = display.getVisibleRange().getStart() == 0;
                display.setVisibleRange(0, display.getVisibleRange().getLength());
                if (!wasOnFirstPage) continue;
                this.onRangeChanged((HasData<JarListPageRow>)display);
            }
        }

        protected void refresh() {
            for (HasData display : this.getDataDisplays()) {
                this.onRangeChanged((HasData<JarListPageRow>)display);
            }
        }

        protected void onRangeChanged(HasData<JarListPageRow> display) {
            Range range = display.getVisibleRange();
            JarListPageRequest request = new JarListPageRequest(range.getStart(), Integer.valueOf(range.getLength()), this.filter, this.fileFormats, this.getSortColumnDataStoreName(), this.isSortColumnAscending());
            ((M2RepoService)this.m2RepoService.call((RemoteCallback)new RemoteCallback<PageResponse<JarListPageRow>>(){

                public void callback(PageResponse<JarListPageRow> response) {
                    this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                    this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                }
            })).listArtifacts(request);
        }

        private String getSortColumnDataStoreName() {
            ColumnSortList columnSortList = this.view.getColumnSortList();
            return columnSortList == null || columnSortList.size() == 0 ? null : columnSortList.get(0).getColumn().getDataStoreName();
        }

        private boolean isSortColumnAscending() {
            ColumnSortList columnSortList = this.view.getColumnSortList();
            return columnSortList == null || columnSortList.size() == 0 ? true : columnSortList.get(0).isAscending();
        }
    }
}

