/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.client.upload;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.m2repo.client.event.M2RepoSearchEvent;
import org.guvnor.m2repo.client.upload.UploadFormView;
import org.guvnor.m2repo.utils.FileNameUtilities;
import org.gwtbootstrap3.client.shared.event.ModalHideEvent;
import org.gwtbootstrap3.client.shared.event.ModalHideHandler;
import org.gwtbootstrap3.client.ui.base.form.AbstractForm;
import org.jboss.errai.ioc.client.container.SyncBeanManager;

@Dependent
public class UploadFormPresenter
implements UploadFormView.Presenter {
    private Event<M2RepoSearchEvent> searchEvent;
    private UploadFormView view;

    @Inject
    public UploadFormPresenter(UploadFormView view, Event<M2RepoSearchEvent> searchEvent, final SyncBeanManager iocManager) {
        this.view = view;
        view.addHideHandler(new ModalHideHandler(){

            public void onHide(ModalHideEvent hideEvent) {
                iocManager.destroyBean((Object)UploadFormPresenter.this);
            }
        });
        this.searchEvent = searchEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    @Override
    public void handleSubmitComplete(AbstractForm.SubmitCompleteEvent event) {
        this.view.hideUploadingBusy();
        if ("OK".equalsIgnoreCase(event.getResults())) {
            this.view.showUploadedSuccessfullyMessage();
            this.view.hideGAVInputs();
            this.fireSearchEvent();
            this.view.hide();
        } else if ("MISSING_POM".equalsIgnoreCase(event.getResults())) {
            this.view.showInvalidJarNoPomWarning();
            this.view.showGAVInputs();
        } else if ("UNABLE_TO_PARSE_POM".equalsIgnoreCase(event.getResults())) {
            this.view.showInvalidPomWarning();
            this.view.hide();
        } else {
            this.view.showUploadFailedError(event.getResults());
            this.view.hideGAVInputs();
            this.view.hide();
        }
    }

    @Override
    public boolean isFileNameValid() {
        String fileName = this.view.getFileName();
        if (fileName == null || "".equals(fileName)) {
            this.view.showSelectFileUploadWarning();
            return false;
        }
        if (!FileNameUtilities.isValid((String)fileName)) {
            this.view.showUnsupportedFileTypeWarning();
            return false;
        }
        this.view.showUploadingBusy();
        return true;
    }

    public void showView() {
        this.view.show();
    }

    public void fireSearchEvent() {
        this.searchEvent.fire((Object)new M2RepoSearchEvent());
    }
}

