/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.client.widgets;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import javax.enterprise.context.Dependent;
import org.guvnor.m2repo.client.editor.JarDetailPopup;
import org.guvnor.m2repo.client.resources.i18n.M2RepoEditorConstants;
import org.guvnor.m2repo.client.widgets.ArtifactListPresenter;
import org.guvnor.m2repo.client.widgets.ArtifactListView;
import org.guvnor.m2repo.client.widgets.ColumnType;
import org.guvnor.m2repo.model.JarListPageRow;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;

@Dependent
public class ArtifactListViewImpl
extends Composite
implements ArtifactListView {
    private ArtifactListViewImplWidgetBinder uiBinder = (ArtifactListViewImplWidgetBinder)GWT.create(ArtifactListViewImplWidgetBinder.class);
    @UiField(provided=true)
    final PagedTable<JarListPageRow> dataGrid = new PagedTable();
    protected ArtifactListPresenter presenter;

    public ArtifactListViewImpl() {
        this.initWidget((Widget)this.uiBinder.createAndBindUi(this));
    }

    @Override
    public void setup(ColumnType ... _columns) {
        HashSet<ColumnType> columns = new HashSet<ColumnType>(Arrays.asList(_columns));
        this.dataGrid.setEmptyTableCaption(M2RepoEditorConstants.INSTANCE.NoArtifactAvailable());
        if (columns.contains((Object)ColumnType.NAME)) {
            Column<JarListPageRow, String> nameColumn = new Column<JarListPageRow, String>((Cell)new TextCell()){

                public String getValue(JarListPageRow row) {
                    return row.getName();
                }
            };
            nameColumn.setSortable(true);
            nameColumn.setDataStoreName("org.guvnor.m2repo.model.name");
            this.addColumn(nameColumn, M2RepoEditorConstants.INSTANCE.Name());
        }
        if (columns.contains((Object)ColumnType.GAV)) {
            Column<JarListPageRow, String> gavColumn = new Column<JarListPageRow, String>((Cell)new TextCell()){

                public String getValue(JarListPageRow row) {
                    return row.getGav().toString();
                }
            };
            gavColumn.setSortable(true);
            gavColumn.setDataStoreName("org.guvnor.m2repo.model.gav");
            this.addColumn(gavColumn, M2RepoEditorConstants.INSTANCE.GAV());
        }
        if (columns.contains((Object)ColumnType.LAST_MODIFIED)) {
            Column<JarListPageRow, Date> lastModifiedColumn = new Column<JarListPageRow, Date>((Cell)new DateCell((DateTimeFormat)com.google.gwt.i18n.client.DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

                public Date getValue(JarListPageRow row) {
                    return row.getLastModified();
                }
            };
            lastModifiedColumn.setSortable(true);
            lastModifiedColumn.setDataStoreName("org.guvnor.m2repo.model.last.modified");
            this.addColumn(lastModifiedColumn, M2RepoEditorConstants.INSTANCE.LastModified(), false);
        }
        this.dataGrid.addColumnSortHandler((ColumnSortEvent.Handler)new ColumnSortEvent.AsyncHandler(this.dataGrid));
    }

    @Override
    public void setContentHeight(String s) {
        this.dataGrid.setHeight(s);
    }

    public void init(ArtifactListPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void addColumn(Column<JarListPageRow, ?> column, String caption) {
        this.dataGrid.addColumn(column, caption);
    }

    @Override
    public void addColumn(Column<JarListPageRow, ?> column, String caption, boolean visible) {
        this.dataGrid.addColumn(column, caption, visible);
    }

    @Override
    public void addColumn(Column<JarListPageRow, ?> column, String caption, double width, Style.Unit unit) {
        this.dataGrid.addColumn(column, caption);
        this.dataGrid.setColumnWidth(column, width, unit);
    }

    @Override
    public void addColumn(Column<JarListPageRow, ?> column, String caption, boolean visible, double width, Style.Unit unit) {
        this.dataGrid.addColumn(column, caption, visible);
        this.dataGrid.setColumnWidth(column, width, unit);
    }

    @Override
    public void showPom(String pomText) {
        JarDetailPopup popup = new JarDetailPopup(pomText);
        popup.show();
    }

    @Override
    public HasData<JarListPageRow> getDisplay() {
        return this.dataGrid;
    }

    @Override
    public ColumnSortList getColumnSortList() {
        return this.dataGrid.getColumnSortList();
    }

    @Override
    public String getRefreshNotificationMessage() {
        return M2RepoEditorConstants.INSTANCE.RefreshedSuccessfully();
    }

    static interface ArtifactListViewImplWidgetBinder
    extends UiBinder<Widget, ArtifactListViewImpl> {
    }
}

