/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.UploadPack;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;

public class GitUploadCommand
extends BaseGitCommand {
    public GitUploadCommand(String command, JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, FileSystemAuthorizer fileSystemAuthorizer) {
        super(command, fileSystemAuthorizer, repositoryResolver);
    }

    @Override
    protected String getCommandName() {
        return "git-upload-pack";
    }

    @Override
    protected void execute(FileSystemUser user, Repository repository, InputStream in, OutputStream out, OutputStream err) {
        UploadPack up = new UploadPack(repository);
        PackConfig config = new PackConfig(repository);
        config.setCompressionLevel(9);
        up.setPackConfig(config);
        try {
            up.upload(in, out, err);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

