/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.git;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.daemon.git.DaemonClient;
import org.uberfire.java.nio.fs.jgit.daemon.git.DaemonService;

public class Daemon {
    public static final int DEFAULT_PORT = 9418;
    private static final int BACKLOG = 5;
    private InetSocketAddress myAddress;
    private final DaemonService[] services;
    private final AtomicBoolean run = new AtomicBoolean(false);
    private int timeout;
    private volatile RepositoryResolver<DaemonClient> repositoryResolver;
    private volatile UploadPackFactory<DaemonClient> uploadPackFactory;
    private ServerSocket listenSock = null;
    private final Executor acceptThreadPool;

    public Daemon(InetSocketAddress addr, Executor acceptThreadPool) {
        this.myAddress = addr;
        this.acceptThreadPool = (Executor)PortablePreconditions.checkNotNull((String)"acceptThreadPool", (Object)acceptThreadPool);
        this.repositoryResolver = RepositoryResolver.NONE;
        this.uploadPackFactory = new UploadPackFactory<DaemonClient>(){

            public UploadPack create(DaemonClient req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                UploadPack up = new UploadPack(db);
                up.setTimeout(Daemon.this.getTimeout());
                PackConfig config = new PackConfig(db);
                config.setCompressionLevel(9);
                up.setPackConfig(config);
                return up;
            }
        };
        this.services = new DaemonService[]{new DaemonService("upload-pack", "uploadpack"){
            {
                this.setEnabled(true);
            }

            @Override
            protected void execute(DaemonClient dc, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
                UploadPack up = Daemon.this.uploadPackFactory.create((Object)dc, db);
                InputStream in = dc.getInputStream();
                OutputStream out = dc.getOutputStream();
                up.upload(in, out, null);
            }
        }};
    }

    public synchronized InetSocketAddress getAddress() {
        return this.myAddress;
    }

    public synchronized DaemonService getService(String name) {
        if (!name.startsWith("git-")) {
            name = "git-" + name;
        }
        for (DaemonService s : this.services) {
            if (!s.getCommandName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public void setRepositoryResolver(RepositoryResolver<DaemonClient> resolver) {
        this.repositoryResolver = resolver;
    }

    public void setUploadPackFactory(UploadPackFactory<DaemonClient> factory) {
        this.uploadPackFactory = factory != null ? factory : UploadPackFactory.DISABLED;
    }

    public synchronized void start() throws IOException {
        if (this.run.get()) {
            throw new IllegalStateException(JGitText.get().daemonAlreadyRunning);
        }
        InetAddress listenAddress = this.myAddress != null ? this.myAddress.getAddress() : null;
        int listenPort = this.myAddress != null ? this.myAddress.getPort() : 0;
        try {
            this.listenSock = new ServerSocket(listenPort, 5, listenAddress);
        }
        catch (IOException e) {
            throw new IOException("Failed to open server socket for " + listenAddress + ":" + listenPort, e);
        }
        this.myAddress = (InetSocketAddress)this.listenSock.getLocalSocketAddress();
        this.run.set(true);
        this.acceptThreadPool.execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "Git-Daemon-Accept";
            }

            public void run() {
                while (Daemon.this.isRunning() && !Thread.currentThread().isInterrupted()) {
                    try {
                        Daemon.this.listenSock.setSoTimeout(5000);
                        Daemon.this.startClient(Daemon.this.listenSock.accept());
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (IOException e) {
                        // empty catch block
                        break;
                    }
                }
                Daemon.this.stop();
            }
        });
    }

    public boolean isRunning() {
        return this.run.get();
    }

    public synchronized void stop() {
        if (this.run.getAndSet(false)) {
            try {
                this.listenSock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void startClient(final Socket s) {
        final DaemonClient dc = new DaemonClient(this);
        final SocketAddress peer = s.getRemoteSocketAddress();
        if (peer instanceof InetSocketAddress) {
            dc.setRemoteAddress(((InetSocketAddress)peer).getAddress());
        }
        SimpleAsyncExecutorService.getUnmanagedInstance().execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "Git-Daemon-Client " + peer.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    dc.execute(s);
                }
                catch (ServiceNotEnabledException serviceNotEnabledException) {
                }
                catch (ServiceNotAuthorizedException serviceNotAuthorizedException) {
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        s.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    synchronized DaemonService matchService(String cmd) {
        for (DaemonService d : this.services) {
            if (!d.handles(cmd)) continue;
            return d;
        }
        return null;
    }

    Repository openRepository(DaemonClient client, String name) throws ServiceMayNotContinueException {
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        try {
            return this.repositoryResolver.open((Object)client, name.substring(1));
        }
        catch (RepositoryNotFoundException e) {
            return null;
        }
        catch (ServiceNotAuthorizedException e) {
            return null;
        }
        catch (ServiceNotEnabledException e) {
            return null;
        }
    }
}

