/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public abstract class GitCommand {
    public abstract <T> Optional<T> execute();

    protected RevTree getRevTree(RevWalk revWalk, RevCommit commit) {
        try {
            return revWalk.parseTree((AnyObjectId)commit.getTree().getId());
        }
        catch (IOException e) {
            String message = String.format("An error has ocurred trying to get the Revision Tree from commit (%s)", commit.getId());
            throw new GitException(message, e);
        }
    }

    protected RevCommit getRevCommit(ObjectId startCommitObjectId, RevWalk revWalk) {
        try {
            return revWalk.parseCommit((AnyObjectId)startCommitObjectId);
        }
        catch (IOException e) {
            String message = String.format("An error has ocurred when parsing commit(%s)", startCommitObjectId);
            throw new GitException(message, e);
        }
    }

    protected void isBare(Repository repository) {
        if (!repository.isBare()) {
            throw new IllegalStateException("You cannot squash/rebase in a non BARE repository");
        }
    }

    protected ObjectId getStartCommit(Git git, String startCommitString) {
        ObjectId startCommitObjectId = JGitUtil.resolveObjectId(git, startCommitString);
        if (startCommitObjectId == null) {
            throw new IllegalStateException("Start Commit must be a valid commit");
        }
        return startCommitObjectId;
    }
}

