/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.WriteConfiguration;

public class CreateRepository {
    private final File repoDir;
    private final File hookDir;
    private final KetchLeaderCache leaders;
    private final boolean sslVerify;

    public CreateRepository(File repoDir) {
        this(repoDir, null, null, JGitFileSystemProviderConfiguration.DEFAULT_GIT_HTTP_SSL_VERIFY);
    }

    public CreateRepository(File repoDir, boolean sslVerify) {
        this(repoDir, null, null, sslVerify);
    }

    public CreateRepository(File repoDir, File hookDir) {
        this(repoDir, hookDir, null, JGitFileSystemProviderConfiguration.DEFAULT_GIT_HTTP_SSL_VERIFY);
    }

    public CreateRepository(File repoDir, File hookDir, boolean sslVerify) {
        this(repoDir, hookDir, null, sslVerify);
    }

    public CreateRepository(File repoDir, File hookDir, KetchLeaderCache leaders) {
        this(repoDir, hookDir, leaders, JGitFileSystemProviderConfiguration.DEFAULT_GIT_HTTP_SSL_VERIFY);
    }

    public CreateRepository(File repoDir, File hookDir, KetchLeaderCache leaders, boolean sslVerify) {
        this.repoDir = repoDir;
        this.hookDir = hookDir;
        this.leaders = leaders;
        this.sslVerify = sslVerify;
    }

    public Optional<Git> execute() {
        try {
            boolean newRepository = !this.repoDir.exists();
            org.eclipse.jgit.api.Git _git = org.eclipse.jgit.api.Git.init().setBare(true).setDirectory(this.repoDir).call();
            if (this.leaders != null) {
                new WriteConfiguration(_git.getRepository(), cfg -> {
                    cfg.setInt("core", null, "repositoryformatversion", 1);
                    cfg.setString("extensions", null, "refsStorage", "reftree");
                }).execute();
            }
            Repository repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.repoDir)).build();
            org.eclipse.jgit.api.Git git = new org.eclipse.jgit.api.Git(repo);
            this.setupSSLVerify(repo);
            if (this.setupGitHooks(newRepository)) {
                File repoHookDir = new File(this.repoDir, "hooks");
                try {
                    FileUtils.copyDirectory((File)this.hookDir, (File)repoHookDir);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                for (File file : repoHookDir.listFiles()) {
                    if (file == null || !file.isFile()) continue;
                    file.setExecutable(true);
                }
            }
            return Optional.of(new GitImpl(git, this.leaders));
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private void setupSSLVerify(Repository repo) throws java.io.IOException {
        StoredConfig config = repo.getConfig();
        config.setBoolean("http", null, "sslVerify", this.sslVerify);
        config.save();
    }

    private boolean setupGitHooks(boolean newRepository) {
        return newRepository && this.hookDir != null;
    }
}

