/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import org.eclipse.jgit.lib.RefUpdate;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.PathUtil;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class RemoveRemote {
    final PathUtil pathUtil = new PathUtil();
    private Git git;
    private String ref;
    private String remote;

    public RemoveRemote(Git git, String remote, String ref) {
        this.git = git;
        this.ref = ref;
        this.remote = remote;
    }

    public void execute() {
        try {
            this.git.getRepository().getConfig().unsetSection("remote", this.remote);
            this.git.getRepository().getConfig().save();
            RefUpdate updateRef = this.git.getRepository().updateRef(this.ref, false);
            updateRef.setRefLogMessage(this.ref + " packed-ref deleted", false);
            updateRef.setForceUpdate(true);
            updateRef.delete();
        }
        catch (Exception e) {
            throw new GitException("Error when trying to remove remote", e);
        }
    }
}

