/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.extensions;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.extensions.FileSystemHooks;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;

public class JGitFSHooks {
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitFileSystemImpl.class);

    public static void executeFSHooks(Object fsHook, FileSystemHooks hookType, String fsName) {
        if (fsHook == null) {
            return;
        }
        if (fsHook instanceof List) {
            List hooks = (List)fsHook;
            hooks.forEach(h -> JGitFSHooks.executeHook(h, hookType, fsName));
        } else {
            JGitFSHooks.executeHook(fsHook, hookType, fsName);
        }
    }

    private static void executeHook(Object hook, FileSystemHooks hookType, String fsName) {
        if (hook instanceof FileSystemHooks.FileSystemHook) {
            FileSystemHooks.FileSystemHook fsHook = (FileSystemHooks.FileSystemHook)hook;
            fsHook.execute((Object)fsName);
        } else {
            LOGGER.error("Error executing FS Hook FS " + hookType + " on " + fsName + ". Callback methods should implement FileSystemHooks.FileSystemHook. ");
        }
    }
}

