/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.uberfire.java.nio.fs.jgit.FileSystemLock;

public class FileSystemLockManager {
    final Map<String, FileSystemLock> fileSystemsLocks = new ConcurrentHashMap<String, FileSystemLock>();

    public static FileSystemLockManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    public FileSystemLock getFileSystemLock(File directory, String lockName, TimeUnit lastAccessTimeUnit, long lastAccessThreshold) {
        return this.fileSystemsLocks.computeIfAbsent(directory.getAbsolutePath(), key -> new FileSystemLock(directory, lockName, lastAccessTimeUnit, lastAccessThreshold));
    }

    private static class LazyHolder {
        static final FileSystemLockManager INSTANCE = new FileSystemLockManager();

        private LazyHolder() {
        }
    }
}

