/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.git;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.java.nio.fs.jgit.daemon.common.PortUtil;
import org.uberfire.java.nio.fs.jgit.daemon.filters.HiddenBranchRefFilter;
import org.uberfire.java.nio.fs.jgit.daemon.git.DaemonClient;
import org.uberfire.java.nio.fs.jgit.daemon.git.DaemonService;

public class Daemon {
    private static final Logger LOG = LoggerFactory.getLogger(Daemon.class);
    private static final int BACKLOG = 5;
    private InetSocketAddress myAddress;
    private final DaemonService[] services;
    private final AtomicBoolean run = new AtomicBoolean(false);
    private int timeout;
    private volatile RepositoryResolver<DaemonClient> repositoryResolver;
    private volatile UploadPackFactory<DaemonClient> uploadPackFactory;
    private ServerSocket listenSock = null;
    private ExecutorService executorService;
    private final Executor acceptThreadPool;

    public Daemon(InetSocketAddress addr, Executor acceptThreadPool, ExecutorService executorService) {
        this(addr, acceptThreadPool, executorService, null);
    }

    public Daemon(InetSocketAddress addr, Executor acceptThreadPool, ExecutorService executorService, KetchLeaderCache leaders) {
        this.myAddress = addr;
        this.acceptThreadPool = (Executor)PortablePreconditions.checkNotNull((String)"acceptThreadPool", (Object)acceptThreadPool);
        this.executorService = executorService;
        this.repositoryResolver = RepositoryResolver.NONE;
        this.uploadPackFactory = (req, db) -> {
            UploadPack up = new UploadPack(db);
            up.setTimeout(this.getTimeout());
            up.setRefFilter((RefFilter)new HiddenBranchRefFilter());
            PackConfig config = new PackConfig(db);
            config.setCompressionLevel(9);
            up.setPackConfig(config);
            return up;
        };
        this.services = new DaemonService[]{new DaemonService("upload-pack", "uploadpack"){
            {
                this.setEnabled(true);
            }

            @Override
            protected void execute(DaemonClient dc, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
                UploadPack up = Daemon.this.uploadPackFactory.create((Object)dc, db);
                InputStream in = dc.getInputStream();
                OutputStream out = dc.getOutputStream();
                up.upload(in, out, null);
            }
        }, new DaemonService("receive-pack", "receivepack"){
            {
                this.setEnabled(false);
            }

            @Override
            protected void execute(DaemonClient dc, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
                throw new ServiceNotAuthorizedException();
            }
        }};
    }

    public synchronized InetSocketAddress getAddress() {
        return this.myAddress;
    }

    public synchronized DaemonService getService(String name) {
        if (!name.startsWith("git-")) {
            name = "git-" + name;
        }
        for (DaemonService s : this.services) {
            if (!s.getCommandName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public void setRepositoryResolver(RepositoryResolver<DaemonClient> resolver) {
        this.repositoryResolver = resolver;
    }

    public void setUploadPackFactory(UploadPackFactory<DaemonClient> factory) {
        this.uploadPackFactory = factory != null ? factory : UploadPackFactory.DISABLED;
    }

    public synchronized void start() throws IOException {
        if (this.run.get()) {
            throw new IllegalStateException(JGitText.get().daemonAlreadyRunning);
        }
        InetAddress listenAddress = this.myAddress != null ? this.myAddress.getAddress() : null;
        int listenPort = this.myAddress != null ? this.myAddress.getPort() : 0;
        try {
            this.listenSock = new ServerSocket(PortUtil.validateOrGetNew(listenPort), 5, listenAddress);
        }
        catch (IOException e) {
            throw new IOException("Failed to open server socket for " + listenAddress + ":" + listenPort, e);
        }
        if (this.listenSock.getLocalPort() != listenPort) {
            LOG.error("Git original port {} not available, new free port {} assigned.", (Object)listenPort, (Object)this.listenSock.getLocalPort());
        }
        this.myAddress = (InetSocketAddress)this.listenSock.getLocalSocketAddress();
        this.run.set(true);
        this.acceptThreadPool.execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "Git-Daemon-Accept";
            }

            public void run() {
                while (Daemon.this.isRunning() && !Thread.currentThread().isInterrupted()) {
                    try {
                        Daemon.this.listenSock.setSoTimeout(5000);
                        Daemon.this.startClient(Daemon.this.listenSock.accept());
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (IOException e) {
                        // empty catch block
                        break;
                    }
                }
                Daemon.this.stop();
            }
        });
    }

    public boolean isRunning() {
        return this.run.get();
    }

    public synchronized void stop() {
        if (this.run.getAndSet(false)) {
            try {
                this.listenSock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void startClient(final Socket s) {
        final DaemonClient dc = new DaemonClient(this);
        final SocketAddress peer = s.getRemoteSocketAddress();
        if (peer instanceof InetSocketAddress) {
            dc.setRemoteAddress(((InetSocketAddress)peer).getAddress());
        }
        this.executorService.execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "Git-Daemon-Client " + peer.toString();
            }

            public void run() {
                try {
                    dc.execute(s);
                }
                catch (IOException | ServiceNotAuthorizedException | ServiceNotEnabledException throwable) {
                }
                finally {
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        s.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    synchronized DaemonService matchService(String cmd) {
        for (DaemonService d : this.services) {
            if (!d.handles(cmd)) continue;
            return d;
        }
        return null;
    }

    Repository openRepository(DaemonClient client, String name) throws ServiceMayNotContinueException {
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        try {
            return this.repositoryResolver.open((Object)client, name.substring(1));
        }
        catch (RepositoryNotFoundException | ServiceNotAuthorizedException | ServiceNotEnabledException e) {
            return null;
        }
    }
}

