/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.ws;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.Watchable;
import org.uberfire.java.nio.fs.jgit.ws.JGitWatchService;

public class JGitFileSystemWatchServices
implements Serializable {
    private final Collection<JGitWatchService> watchServices = new CopyOnWriteArrayList<JGitWatchService>();

    public WatchService newWatchService(String fsName) {
        JGitWatchService ws = new JGitWatchService(fsName, p -> this.watchServices.remove(p));
        this.watchServices.add(ws);
        return ws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void publishEvents(final Path watchable, final List<WatchEvent<?>> elist) {
        if (this.watchServices.isEmpty()) {
            return;
        }
        for (JGitWatchService ws : this.watchServices) {
            ws.publish(new WatchKey(){

                public boolean isValid() {
                    return true;
                }

                public List<WatchEvent<?>> pollEvents() {
                    return new CopyOnWriteArrayList(elist);
                }

                public boolean reset() {
                    return !JGitFileSystemWatchServices.this.watchServices.isEmpty();
                }

                public void cancel() {
                }

                public Watchable watchable() {
                    return watchable;
                }
            });
            JGitWatchService jGitWatchService = ws;
            synchronized (jGitWatchService) {
                ws.notifyAll();
            }
        }
    }

    public void close() {
        this.watchServices.forEach(ws -> ws.closeWithoutNotifyParent());
        this.watchServices.clear();
    }
}

