/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.ws;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.ClosedWatchServiceException;
import org.uberfire.java.nio.file.InterruptedException;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;

public class JGitWatchService
implements WatchService {
    private boolean wsClose = false;
    private final Queue<WatchKey> events = new ConcurrentLinkedQueue<WatchKey>();
    private final String fsName;
    private Consumer<JGitWatchService> notifyClose;

    public JGitWatchService(String fsName, Consumer<JGitWatchService> notifyClose) {
        this.fsName = fsName;
        this.notifyClose = notifyClose;
    }

    public WatchKey poll() throws ClosedWatchServiceException {
        return this.events.poll();
    }

    public WatchKey poll(long timeout, TimeUnit unit) throws ClosedWatchServiceException, InterruptedException {
        return this.events.poll();
    }

    public synchronized WatchKey take() throws ClosedWatchServiceException, InterruptedException {
        while (true) {
            if (this.wsClose) {
                throw new ClosedWatchServiceException("This service is closed.");
            }
            if (this.events.size() > 0) {
                return this.events.poll();
            }
            try {
                this.wait();
            }
            catch (java.lang.InterruptedException interruptedException) {
            }
        }
    }

    public boolean isClose() {
        return this.wsClose;
    }

    public synchronized void close() throws IOException {
        this.wsClose = true;
        this.notifyAll();
        this.notifyClose.accept(this);
    }

    synchronized void closeWithoutNotifyParent() {
        this.wsClose = true;
        this.notifyAll();
    }

    public String toString() {
        return "WatchService{FileSystem=" + this.fsName + '}';
    }

    public void publish(WatchKey wk) {
        this.events.add(wk);
    }
}

