/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util;

import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class ProxyAuthenticator
extends Authenticator {
    private final String httpProxyUser;
    private final String httpProxyPassword;
    private final String httpsProxyUser;
    private final String httpsProxyPassword;

    public ProxyAuthenticator(String httpProxyUser, String httpProxyPassword, String httpsProxyUser, String httpsProxyPassword) {
        this.httpProxyUser = httpProxyUser;
        this.httpProxyPassword = httpProxyPassword;
        this.httpsProxyUser = httpsProxyUser;
        this.httpsProxyPassword = httpsProxyPassword;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
            String protocol = this.getRequestingProtocol();
            if (protocol.equalsIgnoreCase("http") && this.httpProxyUser != null && this.httpProxyPassword != null) {
                return new PasswordAuthentication(this.httpProxyUser, this.httpProxyPassword.toCharArray());
            }
            if (protocol.equalsIgnoreCase("https") && this.httpsProxyUser != null && this.httpsProxyPassword != null) {
                return new PasswordAuthentication(this.httpsProxyUser, this.httpsProxyPassword.toCharArray());
            }
        }
        return super.getPasswordAuthentication();
    }
}

