/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateCopyCommitTree;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateDefaultCommitTree;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateMoveCommitTree;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRevertCommitTree;
import org.uberfire.java.nio.fs.jgit.util.model.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.CopyCommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.DefaultCommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.MergeCommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.MoveCommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.RevertCommitContent;

public class Commit {
    private final Git git;
    private final String branchName;
    private final CommitInfo commitInfo;
    private final boolean amend;
    private final ObjectId originId;
    private final CommitContent content;

    public Commit(Git git, String branchName, String name, String email, String message, TimeZone timeZone, Date when, boolean amend, Map<String, File> content) {
        this(git, branchName, new CommitInfo(null, name, email, message, timeZone, when), amend, null, new DefaultCommitContent(content));
    }

    public Commit(Git git, String branchName, CommitInfo commitInfo, boolean amend, ObjectId originId, CommitContent content) {
        this.git = git;
        this.branchName = branchName;
        this.commitInfo = commitInfo;
        this.amend = amend;
        this.content = content;
        try {
            this.originId = originId == null ? git.getLastCommit(branchName) : originId;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public boolean execute() {
        boolean hadEffecitiveCommit = true;
        PersonIdent author = this.buildPersonIdent(this.git, this.commitInfo.getName(), this.commitInfo.getEmail(), this.commitInfo.getTimeZone(), this.commitInfo.getWhen());
        try (ObjectInserter odi = this.git.getRepository().newObjectInserter();){
            ObjectId headId = this.git.getRepository().resolve(this.branchName + "^{commit}");
            Optional<Object> tree = this.content instanceof DefaultCommitContent ? new CreateDefaultCommitTree(this.git, this.originId, odi, (DefaultCommitContent)this.content).execute() : (this.content instanceof MoveCommitContent ? new CreateMoveCommitTree(this.git, this.originId, odi, (MoveCommitContent)this.content).execute() : (this.content instanceof CopyCommitContent ? new CreateCopyCommitTree(this.git, this.originId, odi, (CopyCommitContent)this.content).execute() : (this.content instanceof RevertCommitContent ? new CreateRevertCommitTree(this.git, this.originId, odi, (RevertCommitContent)this.content).execute() : Optional.empty())));
            if (tree.isPresent()) {
                CommitBuilder commit = new CommitBuilder();
                commit.setAuthor(author);
                commit.setCommitter(author);
                commit.setEncoding(Constants.CHARACTER_ENCODING);
                commit.setMessage(this.commitInfo.getMessage());
                if (headId != null) {
                    if (this.content instanceof MergeCommitContent) {
                        commit.setParentIds(((MergeCommitContent)this.content).getParents());
                    } else if (this.amend) {
                        RevCommit previousCommit = this.git.resolveRevCommit(headId);
                        List<RevCommit> p = Arrays.asList(previousCommit.getParents());
                        Collections.reverse(p);
                        commit.setParentIds(p);
                    } else {
                        commit.setParentId((AnyObjectId)headId);
                    }
                }
                commit.setTreeId((AnyObjectId)tree.get());
                ObjectId commitId = odi.insert(commit);
                odi.flush();
                this.git.refUpdate(this.branchName, this.git.resolveRevCommit(commitId));
            } else {
                hadEffecitiveCommit = false;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        return hadEffecitiveCommit;
    }

    private PersonIdent buildPersonIdent(Git git, String name, String _email, TimeZone timeZone, Date when) {
        String email;
        TimeZone tz = timeZone == null ? TimeZone.getDefault() : timeZone;
        String string = email = _email == null ? "" : _email;
        if (name != null) {
            if (when != null) {
                return new PersonIdent(name, email, when, tz);
            }
            return new PersonIdent(name, email);
        }
        return new PersonIdent("system", "system", new Date(), TimeZone.getDefault());
    }
}

