/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.CustomDiffCommand;

public class ListDiffs {
    private final Git git;
    private final ObjectId oldRef;
    private final ObjectId newRef;

    public ListDiffs(Git git, ObjectId oldRef, ObjectId newRef) {
        this.git = git;
        this.oldRef = oldRef;
        this.newRef = newRef;
    }

    public List<DiffEntry> execute() {
        Object object;
        block10: {
            if (this.newRef == null || this.git.getRepository() == null) {
                return Collections.emptyList();
            }
            ObjectReader reader = this.git.getRepository().newObjectReader();
            try {
                CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
                if (this.oldRef != null) {
                    oldTreeIter.reset(reader, (AnyObjectId)this.oldRef);
                }
                CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
                newTreeIter.reset(reader, (AnyObjectId)this.newRef);
                object = new CustomDiffCommand(this.git).setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).setShowNameAndStatusOnly(true).call();
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            reader.close();
        }
        return object;
    }
}

