/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collections;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.cloud.CloudClientFactory;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemUtils;
import org.uberfire.java.nio.fs.k8s.SeekableInMemoryByteChannel;

public class K8SFileChannel
extends SeekableInMemoryByteChannel {
    private static final int CAPACITY = Integer.parseInt(System.getProperty("org.uberfire.java.nio.fs.k8s.max.file.size", String.valueOf(102400)));
    protected CloudClientFactory ccf;
    private Path file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K8SFileChannel(Path file, CloudClientFactory ccf) {
        super(CAPACITY);
        this.file = file;
        this.ccf = ccf;
        K8SFileChannel k8SFileChannel = this;
        synchronized (k8SFileChannel) {
            try {
                this.contents = ccf.executeCloudFunction(client -> K8SFileSystemUtils.getFsObjCM(client, file), KubernetesClient.class).filter(K8SFileSystemUtils::isFile).map(K8SFileSystemUtils::getFsObjContentBytes).orElse(new byte[0]);
            }
            catch (Exception e) {
                this.ccf = null;
                this.file = null;
                super.close();
                throw e;
            }
        }
    }

    @Override
    public void close() {
        try {
            this.ccf.executeCloudFunction(client -> K8SFileSystemUtils.createOrReplaceFSCM(client, this.file, K8SFileSystemUtils.createOrReplaceParentDirFSCM(client, this.file, this.size(), false), Collections.singletonMap("fsobj-content", super.toString()), false), KubernetesClient.class);
        }
        finally {
            this.ccf = null;
            this.file = null;
            super.close();
        }
    }
}

