/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.ClosedWatchServiceException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.fs.cloud.CloudClientFactory;
import org.uberfire.java.nio.fs.k8s.K8SFileSystem;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemUtils;
import org.uberfire.java.nio.fs.k8s.K8SWatchKey;

public class K8SWatchService
implements WatchService {
    private static final Logger logger = LoggerFactory.getLogger(K8SWatchService.class);
    private final CloudClientFactory ccf;
    private final K8SFileSystem fs;
    private final BlockingQueue<WatchKey> buckets = new LinkedBlockingQueue<WatchKey>();
    private final Map<Path, WatchKey> registrations = new ConcurrentHashMap<Path, WatchKey>();
    private final CompletableFuture<Void> closed = new CompletableFuture();

    public K8SWatchService(K8SFileSystem fs) {
        this.fs = fs;
        this.ccf = (CloudClientFactory)fs.provider();
        Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("k8sfs-cm-watcher-thread-%d").build()).execute(() -> this.ccf.executeCloudFunction(this::triageEvents, KubernetesClient.class));
    }

    public void close() {
        logger.info("K8SFileSystem WatchService is closing.");
        if (this.closed.complete(null)) {
            logger.info("K8SFileSystem WatchService closed normally.");
        } else {
            logger.info("K8SFileSystem WatchService has been closed already.");
        }
        this.buckets.clear();
        this.registrations.clear();
    }

    public WatchKey poll() {
        this.checkOpen();
        return (WatchKey)this.buckets.poll();
    }

    public WatchKey poll(long timeout, TimeUnit unit) {
        WatchKey bucket = null;
        this.checkOpen();
        try {
            bucket = this.buckets.poll(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new org.uberfire.java.nio.file.InterruptedException();
        }
        return bucket;
    }

    public WatchKey take() {
        WatchKey bucket = null;
        this.checkOpen();
        try {
            bucket = this.buckets.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new org.uberfire.java.nio.file.InterruptedException();
        }
        return bucket;
    }

    public boolean isClose() {
        return this.closed.isDone();
    }

    protected final void checkOpen() {
        if (this.closed.isDone()) {
            throw new ClosedWatchServiceException();
        }
    }

    private CompletableFuture<Void> triageEvents(KubernetesClient client) {
        block9: {
            logger.info("K8SFileSystem WatchService is starting to watch K8SFileSystem ConfigMap in namespace: [{}]", (Object)client.getNamespace());
            try (Watch watchable = (Watch)((FilterWatchListDeletable)client.configMaps().withLabel("k8s.fs.nio.java.uberfire.org/fsobj-app", K8SFileSystemUtils.APP_NAME)).watch((Object)new Watcher<ConfigMap>(){

                public void eventReceived(Watcher.Action action, ConfigMap fsObjCM) {
                    logger.debug("Event - Action: {}, {} on ConfigMap ", (Object)action, (Object)fsObjCM.getMetadata().getLabels());
                    Path path = K8SFileSystemUtils.getPathByFsObjCM(K8SWatchService.this.fs, fsObjCM);
                    K8SWatchKey key = (K8SWatchKey)K8SWatchService.this.registrations.computeIfAbsent(path, p -> new K8SWatchKey(K8SWatchService.this, (Path)p));
                    K8SFileSystemUtils.mapActionToKind(action).ifPresent(e -> {
                        if (key.postEvent((WatchEvent.Kind)e) && key.isValid() && !key.isQueued() && K8SWatchService.this.buckets.offer(key)) {
                            key.signal();
                        }
                    });
                }

                public void onClose(KubernetesClientException cause) {
                    logger.info("K8SFileSystem ConfigMap Watcher closed.");
                    if (cause != null) {
                        logger.info(cause.getMessage());
                    }
                }
            });){
                logger.info("K8SFileSystem ConfigMap Watcher thread started.");
                this.closed.get();
                logger.info("K8SFileSystem ConfigMap Watcher thread terminated.");
            }
            catch (ExecutionException ee) {
                logger.error("K8SFileSystem ConfigMap Watcher thread terminated with execution exception.", (Throwable)ee);
                this.closed.completeExceptionally(ee);
            }
            catch (Exception e) {
                if (this.closed.isDone()) break block9;
                logger.error("K8SFileSystem ConfigMap Watcher thread terminated with exception.", (Throwable)e);
                this.closed.completeExceptionally(e);
            }
        }
        return this.closed;
    }
}

