/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.channels.SeekableByteChannel;

public class SeekableInMemoryByteChannel
implements SeekableByteChannel {
    private static final String ENCODING = System.getProperty("file.encoding", StandardCharsets.UTF_8.name());
    private int position;
    private int capacity = Integer.MAX_VALUE;
    private boolean open = true;
    protected byte[] contents;

    public SeekableInMemoryByteChannel(int capacity) {
        this();
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeekableInMemoryByteChannel() {
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            this.position = 0;
            this.contents = new byte[0];
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.open = false;
        this.truncate(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer destination) {
        int numBytesToRead;
        this.checkClosed();
        if (destination == null) {
            throw new IllegalArgumentException("Destination buffer must be supplied");
        }
        int spaceInBuffer = destination.remaining();
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            int numBytesRemainingInContent = this.contents.length - this.position;
            if (numBytesRemainingInContent <= 0) {
                return -1;
            }
            numBytesToRead = numBytesRemainingInContent >= spaceInBuffer ? spaceInBuffer : numBytesRemainingInContent;
            destination.put(this.contents, this.position, numBytesToRead);
            this.position += numBytesToRead;
        }
        return numBytesToRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer source) {
        this.checkClosed();
        if (source == null) {
            throw new IllegalArgumentException("Source buffer must be supplied");
        }
        int totalBytes = source.remaining();
        if (totalBytes > this.capacity || this.position + totalBytes > this.capacity) {
            throw new IOException("Reached maximum capacity of [" + this.capacity + "] bytes.");
        }
        byte[] readContents = new byte[totalBytes];
        source.get(readContents, source.position(), readContents.length);
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            this.contents = this.concat(this.contents, readContents, this.position);
            this.position += totalBytes;
            this.truncate(this.position());
        }
        return totalBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position() {
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            return this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeekableByteChannel position(long newPosition) {
        if (newPosition > Integer.MAX_VALUE || newPosition < 0L) {
            throw new IllegalArgumentException("Valid position for this channel is between 0 and 2147483647");
        }
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            this.position = (int)newPosition;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            return this.contents.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeekableByteChannel truncate(long size) {
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This implementation permits a size of 0 to 2147483647 inclusive");
        }
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            int newSize = (int)size;
            int currentSize = (int)this.size();
            if (this.position > newSize) {
                this.position = newSize;
            }
            if (currentSize > newSize) {
                byte[] newContents = new byte[newSize];
                System.arraycopy(this.contents, 0, newContents, 0, newSize);
                this.contents = newContents;
            }
        }
        return this;
    }

    public String toString() {
        return this.convert(this.getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent() {
        byte[] copy;
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            int length = this.contents.length;
            copy = new byte[length];
            System.arraycopy(this.contents, 0, copy, 0, this.contents.length);
        }
        return new ByteArrayInputStream(copy);
    }

    private byte[] concat(byte[] input1, byte[] input2, int position) {
        assert (input1 != null) : "Input 1 must be specified";
        assert (input2 != null) : "Input 2 must be specified";
        assert (position >= 0) : "Position must be 0 or higher";
        int newSize = position + input2.length < input1.length ? input1.length : position + input2.length;
        byte[] merged = new byte[newSize];
        System.arraycopy(input1, 0, merged, 0, input1.length);
        System.arraycopy(input2, 0, merged, position, input2.length);
        return merged;
    }

    private void checkClosed() {
        if (!this.isOpen()) {
            throw new IOException("Channel closed.");
        }
    }

    private String convert(InputStream is) {
        String string;
        block8: {
            final InputStream bis = is;
            try {
                string = new ByteSource(){

                    public InputStream openStream() throws java.io.IOException {
                        return bis;
                    }
                }.asCharSource(Charset.forName(ENCODING)).read();
                if (bis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (java.io.IOException e) {
                    throw new IOException(e.getMessage());
                }
            }
            bis.close();
        }
        return string;
    }
}

