/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.channels.AsynchronousFileChannel;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AccessDeniedException;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.NotLinkException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public interface FileSystemProvider {
    public void forceAsDefault();

    public boolean isDefault();

    public String getScheme();

    public FileSystem newFileSystem(URI var1, Map<String, ?> var2) throws IllegalArgumentException, IOException, SecurityException, FileSystemAlreadyExistsException;

    public FileSystem getFileSystem(URI var1) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException;

    public Path getPath(URI var1) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException;

    public FileSystem newFileSystem(Path var1, Map<String, ?> var2) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

    public InputStream newInputStream(Path var1, OpenOption ... var2) throws IllegalArgumentException, UnsupportedOperationException, NoSuchFileException, IOException, SecurityException;

    public OutputStream newOutputStream(Path var1, OpenOption ... var2) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

    public FileChannel newFileChannel(Path var1, Set<? extends OpenOption> var2, FileAttribute<?> ... var3) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

    public AsynchronousFileChannel newAsynchronousFileChannel(Path var1, Set<? extends OpenOption> var2, ExecutorService var3, FileAttribute<?> ... var4) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

    public SeekableByteChannel newByteChannel(Path var1, Set<? extends OpenOption> var2, FileAttribute<?> ... var3) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public DirectoryStream<Path> newDirectoryStream(Path var1, DirectoryStream.Filter<Path> var2) throws NotDirectoryException, IOException, SecurityException;

    public void createDirectory(Path var1, FileAttribute<?> ... var2) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public void createSymbolicLink(Path var1, Path var2, FileAttribute<?> ... var3) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public void createLink(Path var1, Path var2) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public void delete(Path var1, DeleteOption ... var2) throws DirectoryNotEmptyException, NoSuchFileException, IOException, SecurityException;

    public boolean deleteIfExists(Path var1, DeleteOption ... var2) throws DirectoryNotEmptyException, IOException, SecurityException;

    public Path readSymbolicLink(Path var1) throws UnsupportedOperationException, NotLinkException, IOException, SecurityException;

    public void copy(Path var1, Path var2, CopyOption ... var3) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException;

    public void move(Path var1, Path var2, CopyOption ... var3) throws DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException;

    public boolean isSameFile(Path var1, Path var2) throws IOException, SecurityException;

    public boolean isHidden(Path var1) throws IllegalArgumentException, IOException, SecurityException;

    public FileStore getFileStore(Path var1) throws IOException, SecurityException;

    public void checkAccess(Path var1, AccessMode ... var2) throws UnsupportedOperationException, NoSuchFileException, AccessDeniedException, IOException, SecurityException;

    public <V extends FileAttributeView> V getFileAttributeView(Path var1, Class<V> var2, LinkOption ... var3) throws NoSuchFileException;

    public <A extends BasicFileAttributes> A readAttributes(Path var1, Class<A> var2, LinkOption ... var3) throws NoSuchFileException, UnsupportedOperationException, IOException, SecurityException;

    public Map<String, Object> readAttributes(Path var1, String var2, LinkOption ... var3) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException;

    public void setAttribute(Path var1, String var2, Object var3, LinkOption ... var4) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException;
}

