/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.screen;

import java.util.HashMap;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.preferences.client.event.HierarchyItemFormInitializationEvent;
import org.uberfire.ext.preferences.client.event.HierarchyItemSelectedEvent;
import org.uberfire.ext.preferences.client.utils.PreferenceFormBeansInfo;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@WorkbenchScreen(identifier="PreferencesRootScreen")
public class PreferencesRootScreen {
    public static final String IDENTIFIER = "PreferencesRootScreen";
    private final View view;
    private final PlaceManager placeManager;
    private final PreferenceFormBeansInfo preferenceFormBeansInfo;
    private final Event<HierarchyItemFormInitializationEvent> hierarchyItemFormInitializationEvent;
    private PlaceRequest openedPreferencePlaceRequest;

    @Inject
    public PreferencesRootScreen(View view, PlaceManager placeManager, PreferenceFormBeansInfo preferenceFormBeansInfo, Event<HierarchyItemFormInitializationEvent> hierarchyItemFormInitializationEvent) {
        this.view = view;
        this.placeManager = placeManager;
        this.preferenceFormBeansInfo = preferenceFormBeansInfo;
        this.hierarchyItemFormInitializationEvent = hierarchyItemFormInitializationEvent;
    }

    @OnStartup
    public void setup() {
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("PreferencesCentralNavBarScreen"), this.view.getNavbarContainer());
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("PreferencesCentralActionsScreen"), this.view.getActionsContainer());
    }

    @OnClose
    public void onClose() {
        this.placeManager.closePlace("PreferencesCentralNavBarScreen");
        this.placeManager.closePlace("PreferencesCentralActionsScreen");
    }

    public void hierarchyItemSelectedEvent(@Observes HierarchyItemSelectedEvent hierarchyItemSelectedEvent) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", hierarchyItemSelectedEvent.getItemId());
        parameters.put("title", this.view.getTranslation(hierarchyItemSelectedEvent.getPreference().bundleKey()));
        HTMLElement editorContainer = this.view.getEditorContainer();
        if (this.openedPreferencePlaceRequest != null) {
            this.placeManager.closePlace(this.openedPreferencePlaceRequest);
        }
        this.openedPreferencePlaceRequest = new DefaultPlaceRequest(this.getPreferenceFormIdentifier(hierarchyItemSelectedEvent.getPreferenceIdentifier()), parameters);
        this.placeManager.goTo(this.openedPreferencePlaceRequest, editorContainer);
        HierarchyItemFormInitializationEvent event = new HierarchyItemFormInitializationEvent(hierarchyItemSelectedEvent.getHierarchyElement());
        this.hierarchyItemFormInitializationEvent.fire((Object)event);
    }

    public String getPreferenceFormIdentifier(String preferenceIdentifier) {
        String customForm = this.preferenceFormBeansInfo.getPreferenceFormFor(preferenceIdentifier);
        return customForm != null ? customForm : "org.uberfire.ext.preferences.client.central.form.DefaultPreferenceForm";
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Preferences Root Screen";
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<PreferencesRootScreen> {
        public HTMLElement getNavbarContainer();

        public HTMLElement getEditorContainer();

        public HTMLElement getActionsContainer();

        public String getTranslation(String var1);
    }
}

