/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.admin.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.annotations.Customizable;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.preferences.client.admin.page.AdminPage;
import org.uberfire.ext.preferences.client.admin.page.AdminPageOptions;
import org.uberfire.ext.preferences.client.admin.page.AdminTool;
import org.uberfire.ext.preferences.client.event.PreferencesCentralInitializationEvent;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;

@ApplicationScoped
public class AdminPageImpl
implements AdminPage {
    private PlaceManager placeManager;
    private Event<PreferencesCentralInitializationEvent> preferencesCentralInitializationEvent;
    private PreferenceScopeResolutionStrategy resolutionStrategy;
    private UberfireBreadcrumbs breadcrumbs;
    private TranslationService translationService;
    private Map<String, String> screenTitleByIdentifier;
    private Map<String, Map<String, List<AdminTool>>> toolsByCategoryByScreen;
    private String defaultScreen;

    public AdminPageImpl() {
        this(null, null, null, null, null);
    }

    @Inject
    public AdminPageImpl(PlaceManager placeManager, Event<PreferencesCentralInitializationEvent> preferencesCentralInitializationEvent, @Customizable PreferenceScopeResolutionStrategy resolutionStrategy, UberfireBreadcrumbs breadcrumbs, TranslationService translationService) {
        this.placeManager = placeManager;
        this.preferencesCentralInitializationEvent = preferencesCentralInitializationEvent;
        this.resolutionStrategy = resolutionStrategy;
        this.breadcrumbs = breadcrumbs;
        this.translationService = translationService;
        this.toolsByCategoryByScreen = new HashMap<String, Map<String, List<AdminTool>>>();
        this.screenTitleByIdentifier = new HashMap<String, String>();
    }

    @Override
    public void addScreen(String identifier, String title) {
        if (identifier == null || identifier.isEmpty()) {
            throw new RuntimeException("The screen identifier must be not empty.");
        }
        this.screenTitleByIdentifier.put(identifier, title);
        this.toolsByCategoryByScreen.put(identifier, new LinkedHashMap());
    }

    @Override
    public void addTool(String screen, String title, Set<String> iconCss, String category, Command command, ParameterizedCommand<ParameterizedCommand<Integer>> counterCommand) {
        if (screen == null || screen.isEmpty()) {
            throw new RuntimeException("The screen identifier must be not empty.");
        }
        if (this.screenTitleByIdentifier.get(screen) == null) {
            throw new RuntimeException("The screen must be added before it is used.");
        }
        if (category == null || category.isEmpty()) {
            throw new RuntimeException("The category identifier must be not empty.");
        }
        Map<String, List<AdminTool>> toolsByCategory = this.toolsByCategoryByScreen.get(screen);
        List<AdminTool> tools = toolsByCategory.get(category);
        if (tools == null) {
            tools = new ArrayList<AdminTool>();
            toolsByCategory.put(category, tools);
        }
        AdminTool tool = new AdminTool(title, iconCss, category, command, counterCommand);
        tools.add(tool);
    }

    @Override
    public void addTool(String screen, String title, Set<String> iconCss, String category, Command command) {
        this.addTool(screen, title, iconCss, category, command, null);
    }

    @Override
    public void addPreference(String screen, String identifier, String title, Set<String> iconCss, String category, AdminPageOptions ... options) {
        this.addPreference(screen, identifier, title, iconCss, category, (Supplier<PreferenceScopeResolutionStrategyInfo>)null, options);
    }

    @Override
    public void addPreference(String screen, String identifier, String title, Set<String> iconCss, String category, Supplier<PreferenceScopeResolutionStrategyInfo> customScopeResolutionStrategySupplier, AdminPageOptions ... options) {
        this.addPreference(screen, identifier, title, iconCss, category, customScopeResolutionStrategySupplier, (PreferenceScope)null, options);
    }

    @Override
    public void addPreference(String screen, String identifier, String title, Set<String> iconCss, String category, PreferenceScope preferenceScope, AdminPageOptions ... options) {
        this.addPreference(screen, identifier, title, iconCss, category, null, preferenceScope, options);
    }

    @Override
    public void addPreference(String screen, String identifier, String title, Set<String> iconCss, String category, Supplier<PreferenceScopeResolutionStrategyInfo> customScopeResolutionStrategySupplier, PreferenceScope preferenceScope, AdminPageOptions ... options) {
        this.addTool(screen, title, iconCss, category, () -> {
            Command accessCommand = () -> this.lambda$null$0((Supplier)customScopeResolutionStrategySupplier, identifier, preferenceScope);
            accessCommand.execute();
            if (this.hasOption(options, AdminPageOptions.WITH_BREADCRUMBS)) {
                this.breadcrumbs.clearBreadcrumbs("PreferencesCentralPerspective");
                this.breadcrumbs.addBreadCrumb("PreferencesCentralPerspective", this.translationService.format("Admin", new Object[0]), (PlaceRequest)new DefaultPlaceRequest("AdminPagePerspective"));
                this.breadcrumbs.addBreadCrumb("PreferencesCentralPerspective", title, accessCommand);
            }
        });
    }

    @Override
    public Map<String, List<AdminTool>> getToolsByCategory(String screen) {
        return this.toolsByCategoryByScreen.get(screen);
    }

    @Override
    public String getScreenTitle(String screen) {
        return this.screenTitleByIdentifier.get(screen);
    }

    @Override
    public String getDefaultScreen() {
        return this.defaultScreen;
    }

    @Override
    public void setDefaultScreen(String defaultScreen) {
        this.defaultScreen = defaultScreen;
    }

    private boolean hasOption(AdminPageOptions[] options, AdminPageOptions option) {
        if (options != null) {
            for (AdminPageOptions o : options) {
                if (!o.equals((Object)option)) continue;
                return true;
            }
        }
        return false;
    }

    private /* synthetic */ void lambda$null$0(Supplier customScopeResolutionStrategySupplier, String identifier, PreferenceScope preferenceScope) {
        PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy = customScopeResolutionStrategySupplier != null ? (PreferenceScopeResolutionStrategyInfo)customScopeResolutionStrategySupplier.get() : null;
        PreferencesCentralInitializationEvent initEvent = new PreferencesCentralInitializationEvent(identifier, customScopeResolutionStrategy, preferenceScope);
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("PreferencesCentralPerspective"));
        this.preferencesCentralInitializationEvent.fire((Object)initEvent);
    }
}

