/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.tree;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyItemPresenter;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyStructurePresenter;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyStructureView;
import org.uberfire.ext.preferences.client.central.tree.TreeHierarchyInternalItemPresenter;
import org.uberfire.ext.preferences.client.central.tree.TreeHierarchyLeafItemPresenter;
import org.uberfire.ext.preferences.client.central.tree.TreeView;
import org.uberfire.ext.preferences.client.event.HierarchyItemFormInitializationEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralSaveEvent;
import org.uberfire.ext.preferences.client.utils.PreferenceFormBeansInfo;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.bean.BasePreference;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.bean.PreferenceBeanServerStore;
import org.uberfire.preferences.shared.bean.PreferenceBeanStore;
import org.uberfire.preferences.shared.bean.PreferenceHierarchyElement;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.workbench.events.NotificationEvent;

@TreeView
@Dependent
public class TreeHierarchyStructurePresenter
implements HierarchyStructurePresenter {
    private final View view;
    private final Caller<PreferenceBeanServerStore> preferenceBeanServerStoreCaller;
    private final ManagedInstance<TreeHierarchyInternalItemPresenter> treeHierarchyInternalItemPresenterProvider;
    private final ManagedInstance<TreeHierarchyLeafItemPresenter> treeHierarchyLeafItemPresenterProvider;
    private final Event<HierarchyItemFormInitializationEvent> hierarchyItemFormInitializationEvent;
    private final PlaceManager placeManager;
    private final PreferenceBeanStore store;
    private final Event<NotificationEvent> notification;
    private final PreferenceFormBeansInfo preferenceFormBeansInfo;
    private HierarchyItemPresenter hierarchyItem;
    private PreferenceHierarchyElement<?> preferenceElement;
    private PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategyInfo;
    private PreferenceScope scope;

    @Inject
    public TreeHierarchyStructurePresenter(View view, Caller<PreferenceBeanServerStore> preferenceBeanServerStoreCaller, ManagedInstance<TreeHierarchyInternalItemPresenter> treeHierarchyInternalItemPresenterProvider, ManagedInstance<TreeHierarchyLeafItemPresenter> treeHierarchyLeafItemPresenterProvider, Event<HierarchyItemFormInitializationEvent> hierarchyItemFormInitializationEvent, PlaceManager placeManager, PreferenceBeanStore store, Event<NotificationEvent> notification, PreferenceFormBeansInfo preferenceFormBeansInfo) {
        this.view = view;
        this.preferenceBeanServerStoreCaller = preferenceBeanServerStoreCaller;
        this.treeHierarchyInternalItemPresenterProvider = treeHierarchyInternalItemPresenterProvider;
        this.treeHierarchyLeafItemPresenterProvider = treeHierarchyLeafItemPresenterProvider;
        this.hierarchyItemFormInitializationEvent = hierarchyItemFormInitializationEvent;
        this.placeManager = placeManager;
        this.store = store;
        this.notification = notification;
        this.preferenceFormBeansInfo = preferenceFormBeansInfo;
    }

    @Override
    public void init(String rootIdentifier, PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategyInfo, PreferenceScope scope) {
        TreeHierarchyStructurePresenter presenter = this;
        this.customScopeResolutionStrategyInfo = customScopeResolutionStrategyInfo;
        this.scope = scope;
        RemoteCallback successCallback = rootPreference -> {
            this.preferenceElement = rootPreference;
            this.setupHierarchyItem((PreferenceHierarchyElement<?>)rootPreference);
            this.view.init(presenter);
        };
        ErrorCallback errorCallback = (message, throwable) -> {
            throw new RuntimeException(throwable);
        };
        if (customScopeResolutionStrategyInfo != null) {
            ((PreferenceBeanServerStore)this.preferenceBeanServerStoreCaller.call(successCallback, errorCallback)).buildHierarchyStructureForPreference(rootIdentifier, customScopeResolutionStrategyInfo);
        } else {
            ((PreferenceBeanServerStore)this.preferenceBeanServerStoreCaller.call(successCallback, errorCallback)).buildHierarchyStructureForPreference(rootIdentifier);
        }
    }

    public void saveEvent(@Observes PreferencesCentralSaveEvent event) {
        Collection<BasePreferencePortable<? extends BasePreference<?>>> preferencesToSave = this.getPreferencesToSave(this.preferenceElement);
        Command successCallback = () -> this.notification.fire((Object)new NotificationEvent(this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
        ParameterizedCommand errorCallback = parameter -> this.notification.fire((Object)new NotificationEvent(this.view.getSaveErrorMessage(parameter.getMessage()), NotificationEvent.NotificationType.ERROR));
        if (this.scope != null) {
            this.store.save(preferencesToSave, this.scope, successCallback, errorCallback);
        } else if (this.customScopeResolutionStrategyInfo != null) {
            this.store.save(preferencesToSave, this.customScopeResolutionStrategyInfo, successCallback, errorCallback);
        } else {
            this.store.save(preferencesToSave, successCallback, errorCallback);
        }
    }

    void setupHierarchyItem(PreferenceHierarchyElement<?> rootPreference) {
        this.hierarchyItem = rootPreference.hasChildren() ? (HierarchyItemPresenter)this.treeHierarchyInternalItemPresenterProvider.get() : (HierarchyItemPresenter)this.treeHierarchyLeafItemPresenterProvider.get();
        this.hierarchyItem.init(rootPreference, 0, !rootPreference.isSelectable());
        if (rootPreference.isSelectable()) {
            this.hierarchyItem.fireSelect();
        }
    }

    Collection<BasePreferencePortable<? extends BasePreference<?>>> getPreferencesToSave(PreferenceHierarchyElement<?> preferenceElement) {
        ArrayList preferencesToSave = new ArrayList();
        if (preferenceElement.isRoot()) {
            preferencesToSave.add(preferenceElement.getPortablePreference());
        }
        preferenceElement.getChildren().forEach(childElement -> preferencesToSave.addAll(this.getPreferencesToSave((PreferenceHierarchyElement<?>)childElement)));
        return preferencesToSave;
    }

    public HierarchyItemPresenter getHierarchyItem() {
        return this.hierarchyItem;
    }

    @Override
    public View getView() {
        return this.view;
    }

    public static interface View
    extends HierarchyStructureView,
    UberElement<TreeHierarchyStructurePresenter> {
        public String getTranslation(String var1);

        public String getSaveSuccessMessage();

        public String getSaveErrorMessage(String var1);
    }
}

