/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.admin;

import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.preferences.client.admin.category.AdminPageCategoryPresenter;
import org.uberfire.ext.preferences.client.admin.page.AdminPage;
import org.uberfire.ext.preferences.client.admin.page.AdminTool;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@WorkbenchScreen(identifier="AdminPagePresenter")
public class AdminPagePresenter {
    public static final String IDENTIFIER = "AdminPagePresenter";
    private final View view;
    private final AdminPage adminPage;
    private final ManagedInstance<AdminPageCategoryPresenter> categoryPresenterProvider;
    private final Event<NotificationEvent> notification;
    private String screen;
    private String perspectiveIdentifierToGoBackTo;

    @Inject
    public AdminPagePresenter(View view, AdminPage adminPage, ManagedInstance<AdminPageCategoryPresenter> categoryPresenterProvider, Event<NotificationEvent> notification) {
        this.view = view;
        this.adminPage = adminPage;
        this.categoryPresenterProvider = categoryPresenterProvider;
        this.notification = notification;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.screen = placeRequest.getParameter("screen", this.adminPage.getDefaultScreen());
        this.perspectiveIdentifierToGoBackTo = placeRequest.getParameter("perspectiveIdentifierToGoBackTo", null);
        this.view.init(this);
        if (this.screen == null) {
            this.notification.fire((Object)new NotificationEvent(this.view.getNoScreenParameterError(), NotificationEvent.NotificationType.ERROR));
        } else {
            this.init(this.screen);
        }
    }

    public void init(String screen) {
        this.screen = screen;
        Map<String, List<AdminTool>> toolsByCategory = this.adminPage.getToolsByCategory(screen);
        if (toolsByCategory != null) {
            toolsByCategory.forEach((category, adminTools) -> {
                AdminPageCategoryPresenter categoryPresenter = (AdminPageCategoryPresenter)this.categoryPresenterProvider.get();
                categoryPresenter.setup((List<AdminTool>)adminTools, screen, this.perspectiveIdentifierToGoBackTo);
                this.view.add(categoryPresenter.getView());
            });
        } else {
            this.notification.fire((Object)new NotificationEvent(this.view.getNoScreenFoundError(screen), NotificationEvent.NotificationType.ERROR));
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.view.getTitle();
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    public AdminPage getAdminPage() {
        return this.adminPage;
    }

    public String getScreen() {
        return this.screen;
    }

    public static interface View
    extends UberElement<AdminPagePresenter> {
        public void add(AdminPageCategoryPresenter.View var1);

        public String getTitle();

        public String getNoScreenParameterError();

        public String getNoScreenFoundError(String var1);
    }
}

