/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.preferences.client.event.HierarchyItemFormInitializationEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralUndoChangesEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldOption;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.properties.editor.model.validators.PropertyFieldValidator;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.preferences.shared.PropertyFormOptions;
import org.uberfire.preferences.shared.PropertyFormType;
import org.uberfire.preferences.shared.PropertyValidator;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.bean.PreferenceHierarchyElement;
import org.uberfire.preferences.shared.impl.validation.ValidationResult;

@WorkbenchScreen(identifier="org.uberfire.ext.preferences.client.central.form.DefaultPreferenceForm")
public class DefaultPreferenceForm {
    public static final String IDENTIFIER = "org.uberfire.ext.preferences.client.central.form.DefaultPreferenceForm";
    private final View view;
    private TranslationService translationService;
    private String id;
    private String title;
    private BasePreferencePortable<?> preference;
    private PropertyEditorCategory category;
    private PreferenceHierarchyElement<?> hierarchyElement;

    @Inject
    public DefaultPreferenceForm(View view, TranslationService translationService) {
        this.view = view;
        this.translationService = translationService;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.id = placeRequest.getParameter("id", null);
        this.title = placeRequest.getParameter("title", null);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.title;
    }

    @WorkbenchPartView
    public IsElement getView() {
        return this.view;
    }

    public void hierarchyItemFormInitializationEvent(@Observes HierarchyItemFormInitializationEvent event) {
        if (this.preference == null && event.getItemId().equals(this.id)) {
            this.preference = event.getPreference();
            this.hierarchyElement = event.getHierarchyElement();
            this.view.init(this);
        }
    }

    public PropertyEditorEvent generatePropertyEditorEvent() {
        if (this.category == null) {
            this.createPropertiesEditorCategory();
        }
        PropertyEditorEvent event = new PropertyEditorEvent(this.id, this.category);
        return event;
    }

    private void createPropertiesEditorCategory() {
        this.category = new PropertyEditorCategory("Properties");
        this.category.setIdEvent(this.id);
        for (Map.Entry property : this.preference.getPropertiesTypes().entrySet()) {
            String propertyName = (String)property.getKey();
            PropertyEditorType propertyType = this.getPropertyEditorType((PropertyFormType)property.getValue());
            Object propertyValue = this.preference.get(propertyName);
            PropertyEditorFieldInfo fieldInfo = this.createFieldInfo(propertyName, propertyType, propertyValue);
            this.category.withField(fieldInfo);
        }
    }

    private void fillEnumValues(Object propertyValue, PropertyEditorFieldInfo fieldInfo) {
        if (propertyValue instanceof Enum) {
            Enum[] enumConstants = (Enum[])((Enum)propertyValue).getDeclaringClass().getEnumConstants();
            List enumValues = Arrays.stream(enumConstants).map(Object::toString).collect(Collectors.toList());
            fieldInfo.withComboValues(enumValues);
        }
    }

    PropertyEditorFieldInfo createFieldInfo(String propertyName, PropertyEditorType propertyType, Object propertyValue) {
        PropertyEditorFieldInfo fieldInfo = new PropertyEditorFieldInfo(this.translationService.format((String)this.hierarchyElement.getBundleKeyByProperty().get(propertyName), new Object[0]), propertyValue != null ? propertyValue.toString() : "", propertyType);
        this.setupFieldValidators(propertyName, fieldInfo);
        this.setupFieldHelpText(propertyName, fieldInfo);
        this.setupFieldOptions(propertyName, fieldInfo);
        this.setupFieldKey(propertyName, fieldInfo);
        if (propertyType == PropertyEditorType.COMBO) {
            this.fillEnumValues(propertyValue, fieldInfo);
        }
        return fieldInfo;
    }

    private void setupFieldOptions(String propertyName, PropertyEditorFieldInfo fieldInfo) {
        for (PropertyFormOptions option : (PropertyFormOptions[])this.hierarchyElement.getFormOptionsByProperty().get(propertyName)) {
            fieldInfo.withOptions(new PropertyEditorFieldOption[]{PropertyEditorFieldOption.valueOf((String)option.name())});
        }
    }

    private void setupFieldHelpText(String propertyName, PropertyEditorFieldInfo fieldInfo) {
        String helpText = (String)this.hierarchyElement.getHelpBundleKeyByProperty().get(propertyName);
        if (helpText != null && !helpText.isEmpty()) {
            fieldInfo.withHelpInfo("", this.translationService.format(helpText, new Object[0]));
        }
    }

    private void setupFieldValidators(String propertyName, PropertyEditorFieldInfo fieldInfo) {
        ArrayList propertyFieldValidators = new ArrayList();
        this.preference.getPropertyValidators(propertyName).stream().forEach(validator -> propertyFieldValidators.add(new PropertyFieldValidator((PropertyValidator)validator){
            private ValidationResult validationResult;
            final /* synthetic */ PropertyValidator val$validator;
            {
                this.val$validator = propertyValidator;
            }

            public boolean validate(Object value) {
                this.validationResult = this.val$validator.validate(value);
                return this.validationResult.isValid();
            }

            public String getValidatorErrorMessage() {
                List validationMessages = this.validationResult.getMessagesBundleKeys();
                if (!this.validationResult.isValid() && !validationMessages.isEmpty()) {
                    return DefaultPreferenceForm.this.translationService.format((String)validationMessages.get(0), new Object[0]);
                }
                return "";
            }
        }));
        int validatorsSize = propertyFieldValidators.size();
        PropertyFieldValidator[] emptyValidatorsArray = new PropertyFieldValidator[validatorsSize];
        PropertyFieldValidator[] validators = propertyFieldValidators.toArray(emptyValidatorsArray);
        fieldInfo.withValidators(validators);
    }

    private void setupFieldKey(String propertyName, PropertyEditorFieldInfo fieldInfo) {
        fieldInfo.withKey(propertyName);
    }

    public void propertyChanged(@Observes PropertyEditorChangeEvent event) {
        if (event.getProperty().getEventId().equals(this.id)) {
            String propertyName = event.getProperty().getKey();
            PropertyFormType propertyType = this.preference.getPropertyType(propertyName);
            Enum<?> newValue = propertyType.fromString(event.getNewValue());
            Object currentValue = this.preference.get(propertyName);
            if (currentValue instanceof Enum) {
                newValue = this.getEnumValue(event, currentValue);
            }
            this.preference.set(propertyName, newValue);
        }
    }

    private Enum<?> getEnumValue(PropertyEditorChangeEvent event, Object currentValue) {
        String selectedValue = event.getProperty().getCurrentStringValue();
        E[] enumConstants = ((Enum)currentValue).getDeclaringClass().getEnumConstants();
        Enum enumValue = Arrays.stream(enumConstants).filter(e -> e.toString().equals(selectedValue)).map(e -> (Enum)e).findFirst().orElseThrow(RuntimeException::new);
        return enumValue;
    }

    public void saveEvent(@Observes PreferencesCentralSaveEvent event) {
        this.createPropertiesEditorCategory();
        this.view.init(this);
    }

    public void undoEvent(@Observes PreferencesCentralUndoChangesEvent event) {
        this.category.undo();
        this.view.init(this);
    }

    public BasePreferencePortable<?> getPreference() {
        return this.preference;
    }

    public PropertyEditorType getPropertyEditorType(PropertyFormType propertyFormType) {
        return PropertyEditorType.valueOf((String)propertyFormType.name());
    }

    public static interface View
    extends UberElement<DefaultPreferenceForm>,
    IsElement {
    }
}

