/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.util.concurrent.ExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.guvnor.common.services.builder.IncrementalBuilderExecutorManager;
import org.guvnor.common.services.builder.IncrementalBuilderExecutorManagerFactory;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.ModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.concurrent.Managed;

@ApplicationScoped
public class IncrementalBuilderExecutorManagerFactoryImpl
implements IncrementalBuilderExecutorManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalBuilderExecutorManagerFactoryImpl.class);
    private final boolean USE_EXECUTOR_SAFE_MODE = Boolean.parseBoolean(System.getProperty("org.uberfire.async.executor.safemode", "false"));
    private ModuleService<? extends Module> moduleService;
    private BuildService buildService;
    private Event<BuildResults> buildResultsEvent;
    private Event<IncrementalBuildResults> incrementalBuildResultsEvent;
    private ExecutorService executorService;
    private IncrementalBuilderExecutorManager executorManager = null;

    @Inject
    public IncrementalBuilderExecutorManagerFactoryImpl(ModuleService<? extends Module> moduleService, BuildService buildService, Event<BuildResults> buildResultsEvent, Event<IncrementalBuildResults> incrementalBuildResultsEvent, @Managed ExecutorService executorService) {
        this.moduleService = moduleService;
        this.buildService = buildService;
        this.buildResultsEvent = buildResultsEvent;
        this.incrementalBuildResultsEvent = incrementalBuildResultsEvent;
        this.executorService = executorService;
    }

    @Override
    public synchronized IncrementalBuilderExecutorManager getExecutorManager() {
        if (this.executorManager == null) {
            IncrementalBuilderExecutorManager _executorManager = null;
            if (!this.USE_EXECUTOR_SAFE_MODE) {
                try {
                    _executorManager = (IncrementalBuilderExecutorManager)InitialContext.doLookup("java:module/IncrementalBuilderExecutorManager");
                }
                catch (Exception e) {
                    LOG.warn("Unable to instantiate EJB Asynchronous Bean. Falling back to Executors' CachedThreadPool.", (Throwable)e);
                }
            } else {
                LOG.info("Use of to Executors' CachedThreadPool has been requested; overriding container provisioning.");
            }
            if (_executorManager == null) {
                this.executorManager = new IncrementalBuilderExecutorManager();
                this.executorManager.setServices(this.moduleService, this.buildService, this.buildResultsEvent, this.incrementalBuildResultsEvent);
                this.executorManager.setExecutorService(this.executorService);
            } else {
                this.executorManager = _executorManager;
            }
        }
        return this.executorManager;
    }
}

