/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContextChangeHandle;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeHandler;
import org.guvnor.common.services.project.events.ModuleUpdatedEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class WorkspaceProjectContext {
    private OrganizationalUnit activeOrganizationalUnit;
    private WorkspaceProject activeWorkspaceProject;
    private Module activeModule;
    private Package activePackage;
    private Map<ProjectContextChangeHandle, WorkspaceProjectContextChangeHandler> changeHandlers = new HashMap<ProjectContextChangeHandle, WorkspaceProjectContextChangeHandler>();
    private Event<WorkspaceProjectContextChangeEvent> contextChangeEvent;

    public WorkspaceProjectContext() {
    }

    @Inject
    public WorkspaceProjectContext(Event<WorkspaceProjectContextChangeEvent> contextChangeEvent) {
        this.contextChangeEvent = contextChangeEvent;
    }

    public void onOrganizationalUnitUpdated(@Observes UpdatedOrganizationalUnitEvent event) {
        WorkspaceProject updatedWorkspaceProject = new WorkspaceProject(event.getOrganizationalUnit(), this.activeWorkspaceProject.getRepository(), this.activeWorkspaceProject.getBranch(), this.activeWorkspaceProject.getMainModule());
        this.contextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(updatedWorkspaceProject, this.activeModule, this.activePackage));
    }

    public void onModuleUpdated(@Observes ModuleUpdatedEvent moduleUpdatedEvent) {
        if (this.activeModule != null && this.activeModule.getRootPath().equals(moduleUpdatedEvent.getOldModule().getRootPath())) {
            this.contextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(new WorkspaceProject(this.activeWorkspaceProject.getOrganizationalUnit(), this.activeWorkspaceProject.getRepository(), this.activeWorkspaceProject.getBranch(), moduleUpdatedEvent.getNewModule()), moduleUpdatedEvent.getNewModule()));
        }
    }

    public void onProjectContextChanged(@Observes WorkspaceProjectContextChangeEvent event) {
        WorkspaceProjectContextChangeEvent previous = new WorkspaceProjectContextChangeEvent(this.activeWorkspaceProject, this.activeModule, this.activePackage);
        this.setActiveOrganizationalUnit(event.getOrganizationalUnit());
        this.setActiveWorkspaceProject(event.getWorkspaceProject());
        this.setActiveModule(event.getModule());
        this.setActivePackage(event.getPackage());
        for (WorkspaceProjectContextChangeHandler handler : this.changeHandlers.values()) {
            handler.onChange(previous, event);
        }
    }

    public Optional<Path> getActiveRepositoryRoot() {
        return this.getActiveWorkspaceProject().map(proj -> proj.getBranch()).map(branch -> branch.getPath());
    }

    protected void setActiveOrganizationalUnit(OrganizationalUnit activeOrganizationalUnit) {
        this.activeOrganizationalUnit = activeOrganizationalUnit;
    }

    public Optional<OrganizationalUnit> getActiveOrganizationalUnit() {
        return Optional.ofNullable(this.activeOrganizationalUnit);
    }

    protected void setActiveWorkspaceProject(WorkspaceProject activeWorkspaceProject) {
        this.activeWorkspaceProject = activeWorkspaceProject;
    }

    public Optional<WorkspaceProject> getActiveWorkspaceProject() {
        return Optional.ofNullable(this.activeWorkspaceProject);
    }

    public Optional<Module> getActiveModule() {
        return Optional.ofNullable(this.activeModule);
    }

    protected void setActiveModule(Module activeModule) {
        this.activeModule = activeModule;
    }

    public Optional<Package> getActivePackage() {
        return Optional.ofNullable(this.activePackage);
    }

    protected void setActivePackage(Package activePackage) {
        this.activePackage = activePackage;
    }

    public ProjectContextChangeHandle addChangeHandler(WorkspaceProjectContextChangeHandler changeHandler) {
        ProjectContextChangeHandle handle = new ProjectContextChangeHandle();
        this.changeHandlers.put(handle, changeHandler);
        return handle;
    }

    public void removeChangeHandler(ProjectContextChangeHandle projectContextChangeHandle) {
        this.changeHandlers.remove(projectContextChangeHandle);
    }

    public void updateProjectModule(Module module) {
        this.activeModule = module;
    }
}

