/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.security;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.security.RepositoryAction;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;

@ApplicationScoped
public class ProjectController {
    private AuthorizationManager authorizationManager;
    private User user;

    @Inject
    public ProjectController(AuthorizationManager authorizationManager, User user) {
        this.authorizationManager = authorizationManager;
        this.user = user;
    }

    public boolean canCreateProjects() {
        return this.authorizationManager.authorize((ResourceType)Repository.RESOURCE_TYPE, (ResourceAction)RepositoryAction.CREATE, this.user);
    }

    public boolean canReadProjects() {
        return this.authorizationManager.authorize((ResourceType)Repository.RESOURCE_TYPE, RepositoryAction.READ, this.user);
    }

    public boolean canBuildProjects() {
        return this.authorizationManager.authorize((ResourceType)Repository.RESOURCE_TYPE, (ResourceAction)RepositoryAction.BUILD, this.user);
    }

    public boolean canReadProject(WorkspaceProject workspaceProject) {
        return this.authorizationManager.authorize((Resource)workspaceProject.getRepository(), RepositoryAction.READ, this.user);
    }

    public boolean canUpdateProject(WorkspaceProject workspaceProject) {
        return this.authorizationManager.authorize((Resource)workspaceProject.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user);
    }

    public boolean canDeleteProject(WorkspaceProject workspaceProject) {
        return this.authorizationManager.authorize((Resource)workspaceProject.getRepository(), (ResourceAction)RepositoryAction.DELETE, this.user);
    }

    public boolean canBuildProject(WorkspaceProject workspaceProject) {
        return this.authorizationManager.authorize((Resource)workspaceProject.getRepository(), (ResourceAction)RepositoryAction.BUILD, this.user);
    }
}

