/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.common.services.project.client.POMEditorPanelView;
import org.guvnor.common.services.project.client.POMEditorPanelViewImpl;
import org.guvnor.common.services.project.client.resources.ProjectResources;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.TextArea;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class POMEditorPanelViewImplTest {
    @Mock
    POMEditorPanelView.Presenter presenter;
    @GwtMock
    TextBox pomName;
    @GwtMock
    TextArea pomDescription;
    @GwtMock
    HelpBlock pomNameHelp;
    @GwtMock
    FormGroup pomNameGroup;
    POMEditorPanelViewImpl view;

    @Before
    public void setup() {
        this.view = new POMEditorPanelViewImpl();
        this.view.setPresenter(this.presenter);
        this.view.pomNameTextBox = this.pomName;
        this.view.pomDescriptionTextArea = this.pomDescription;
        this.view.pomNameHelpBlock = this.pomNameHelp;
        this.view.pomNameGroup = this.pomNameGroup;
    }

    @Test
    public void testNameChangeHanlder() {
        Mockito.when((Object)this.pomName.getText()).thenReturn((Object)"name");
        this.view.onNameChange((KeyUpEvent)Mockito.mock(KeyUpEvent.class));
        ((POMEditorPanelView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onNameChange("name");
    }

    @Test
    public void testDescriptionChangeHandler() {
        Mockito.when((Object)this.pomDescription.getText()).thenReturn((Object)"descr");
        this.view.onDescriptionChange((ValueChangeEvent)Mockito.mock(ValueChangeEvent.class));
        ((POMEditorPanelView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onDescriptionChange("descr");
    }

    @Test
    public void testValidName() {
        this.view.setValidName(true);
        ((FormGroup)Mockito.verify((Object)this.pomNameGroup, (VerificationMode)Mockito.times((int)1))).setValidationState(ValidationState.NONE);
        ((HelpBlock)Mockito.verify((Object)this.pomNameHelp, (VerificationMode)Mockito.times((int)1))).setText("");
        ((FormGroup)Mockito.verify((Object)this.pomNameGroup, (VerificationMode)Mockito.never())).setValidationState(ValidationState.ERROR);
    }

    @Test
    public void testInvalidName() {
        this.view.setValidName(false);
        ((FormGroup)Mockito.verify((Object)this.pomNameGroup, (VerificationMode)Mockito.times((int)1))).setValidationState(ValidationState.ERROR);
        ((HelpBlock)Mockito.verify((Object)this.pomNameHelp, (VerificationMode)Mockito.times((int)1))).setText(ProjectResources.CONSTANTS.invalidName());
        ((FormGroup)Mockito.verify((Object)this.pomNameGroup, (VerificationMode)Mockito.never())).setValidationState(ValidationState.NONE);
    }
}

