/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.security.ProjectPermissionsService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.RolePermissions;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.security.RepositoryAction;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.client.promise.Promises;
import org.uberfire.mocks.CallerMock;
import org.uberfire.promise.SyncPromises;
import org.uberfire.security.Contributor;
import org.uberfire.security.ContributorType;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class ProjectControllerTest {
    private static final String SHOW_PROJECT_TOOLBAR = "projecttoolbar.show";
    private static final String SHOW_METRICS_TAB = "metricstab.show";
    private static final String SHOW_CHANGEREQUEST_TAB = "changerequesttab.show";
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private User user;
    @Mock
    private ProjectPermissionsService projectPermissionsService;
    private Caller<ProjectPermissionsService> projectPermissionsServiceCaller;
    private Promises promises;
    private ProjectController projectController;

    @Before
    public void setup() {
        this.promises = new SyncPromises();
        this.projectPermissionsServiceCaller = new CallerMock((Object)this.projectPermissionsService);
        this.projectController = (ProjectController)Mockito.spy((Object)new ProjectController(this.authorizationManager, this.user, this.projectPermissionsServiceCaller, this.promises));
    }

    @Test
    public void userCanViewMetricsTabTest() {
        Mockito.when((Object)this.authorizationManager.authorize(SHOW_METRICS_TAB, this.user)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.projectController.canViewMetricsTab());
    }

    @Test
    public void userCanViewMChangeRequestTabTest() {
        Mockito.when((Object)this.authorizationManager.authorize(SHOW_CHANGEREQUEST_TAB, this.user)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.projectController.canViewChangeRequestTab());
    }

    @Test
    public void userCanViewProjectToolbarTest() {
        Mockito.when((Object)this.authorizationManager.authorize(SHOW_PROJECT_TOOLBAR, this.user)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.projectController.canViewProjectToolbar());
    }

    @Test
    public void userCanCreateProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((ResourceType)Repository.RESOURCE_TYPE, (ResourceAction)RepositoryAction.CREATE, this.user)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.projectController.canCreateProjects(project.getOrganizationalUnit()));
    }

    @Test
    public void userCanNotCreateProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((ResourceType)Repository.RESOURCE_TYPE, (ResourceAction)RepositoryAction.CREATE, this.user)).thenReturn((Object)false);
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.CONTRIBUTOR), (Collection)ArgumentMatchers.any());
        Assert.assertFalse((boolean)this.projectController.canCreateProjects(project.getOrganizationalUnit()));
    }

    @Test
    public void spaceContributorCanCreateProjectTest() {
        WorkspaceProject project = this.getProject();
        Collection spaceContributors = project.getOrganizationalUnit().getContributors();
        ((ProjectController)Mockito.doReturn((Object)true).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.CONTRIBUTOR), (Collection)ArgumentMatchers.same((Object)spaceContributors));
        Assert.assertTrue((boolean)this.projectController.canCreateProjects(project.getOrganizationalUnit()));
    }

    @Test
    public void spaceContributorCanNotCreateProjectTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.CONTRIBUTOR), (Collection)ArgumentMatchers.any());
        Assert.assertFalse((boolean)this.projectController.canCreateProjects(project.getOrganizationalUnit()));
    }

    @Test
    public void userCanReadProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), RepositoryAction.READ, this.user)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.projectController.canReadProject(project));
    }

    @Test
    public void userCanNotReadProjectTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        Assert.assertFalse((boolean)this.projectController.canCreateProjects(project.getOrganizationalUnit()));
    }

    @Test
    public void projectContributorCanReadProjectTest() {
        WorkspaceProject project = this.getProject();
        Collection projectContributors = project.getRepository().getContributors();
        ((ProjectController)Mockito.doReturn((Object)true).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.CONTRIBUTOR), (Collection)ArgumentMatchers.same((Object)projectContributors));
        Assert.assertTrue((boolean)this.projectController.canReadProject(project));
    }

    @Test
    public void projectContributorCanNotReadProjectTest() {
        WorkspaceProject project = this.getProject();
        Collection projectContributors = project.getRepository().getContributors();
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.CONTRIBUTOR), (Collection)ArgumentMatchers.same((Object)projectContributors));
        Assert.assertFalse((boolean)this.projectController.canReadProject(project));
    }

    @Test
    public void spaceOwnerCanReadProjectTest() {
        WorkspaceProject project = this.getProject();
        Collection spaceContributors = project.getOrganizationalUnit().getContributors();
        ((ProjectController)Mockito.doReturn((Object)true).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.OWNER), (Collection)ArgumentMatchers.same((Object)spaceContributors));
        Assert.assertTrue((boolean)this.projectController.canReadProject(project));
    }

    @Test
    public void spaceOwnerCanNotReadProjectTest() {
        WorkspaceProject project = this.getProject();
        Collection projectContributors = project.getOrganizationalUnit().getContributors();
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.OWNER), (Collection)ArgumentMatchers.same((Object)projectContributors));
        Assert.assertFalse((boolean)this.projectController.canReadProject(project));
    }

    @Test
    public void userCanUpdateProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)).thenReturn((Object)true);
        this.projectController.canUpdateProject(project).then(userCanUpdateProject -> {
            Assert.assertTrue((boolean)userCanUpdateProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanNotUpdateProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)).thenReturn((Object)false);
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, false, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canUpdateProject(project).then(userCanUpdateProject -> {
            Assert.assertFalse((boolean)userCanUpdateProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanUpdateProjectTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, true, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canUpdateProject(project).then(userCanUpdateProject -> {
            Assert.assertTrue((boolean)userCanUpdateProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanNotUpdateProjectTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, false, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canUpdateProject(project).then(userCanUpdateProject -> {
            Assert.assertFalse((boolean)userCanUpdateProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanUpdateBranchTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)).thenReturn((Object)true);
        this.projectController.canUpdateBranch(project, (Branch)project.getRepository().getBranch("branch2").get()).then(userCanUpdateBranch -> {
            Assert.assertTrue((boolean)userCanUpdateBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanNotUpdateBranchTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)).thenReturn((Object)false);
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, false, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch2");
        this.projectController.canUpdateBranch(project, (Branch)project.getRepository().getBranch("branch2").get()).then(userCanUpdateBranch -> {
            Assert.assertFalse((boolean)userCanUpdateBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanUpdateBranchTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, true, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch2");
        this.projectController.canUpdateBranch(project, (Branch)project.getRepository().getBranch("branch2").get()).then(userCanUpdateBranch -> {
            Assert.assertTrue((boolean)userCanUpdateBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanNotUpdateBranchTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, false, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch2");
        this.projectController.canUpdateBranch(project, (Branch)project.getRepository().getBranch("branch2").get()).then(userCanUpdateBranch -> {
            Assert.assertFalse((boolean)userCanUpdateBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanDeleteProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.DELETE, this.user)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.projectController.canDeleteProject(project));
    }

    @Test
    public void userCanNotDeleteProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.DELETE, this.user)).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.projectController.canDeleteProject(project));
    }

    @Test
    public void projectContributorCanDeleteProjectTest() {
        WorkspaceProject project = this.getProject();
        Collection projectContributors = project.getRepository().getContributors();
        ((ProjectController)Mockito.doReturn((Object)true).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.OWNER), (Collection)ArgumentMatchers.same((Object)projectContributors));
        Assert.assertTrue((boolean)this.projectController.canDeleteProject(project));
    }

    @Test
    public void projectContributorCanNotDeleteProjectTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.OWNER), (Collection)ArgumentMatchers.any());
        Assert.assertFalse((boolean)this.projectController.canDeleteProject(project));
    }

    @Test
    public void spaceContributorCanDeleteProjectTest() {
        WorkspaceProject project = this.getProject();
        Collection spaceContributors = project.getOrganizationalUnit().getContributors();
        ((ProjectController)Mockito.doReturn((Object)true).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.OWNER), (Collection)ArgumentMatchers.same((Object)spaceContributors));
        Assert.assertTrue((boolean)this.projectController.canDeleteProject(project));
    }

    @Test
    public void spaceContributorCanNotDeleteProjectTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).userIsAtLeast((ContributorType)ArgumentMatchers.eq((Object)ContributorType.OWNER), (Collection)ArgumentMatchers.any());
        Assert.assertFalse((boolean)this.projectController.canDeleteProject(project));
    }

    @Test
    public void userCanBuildProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.BUILD, this.user)).thenReturn((Object)true);
        this.projectController.canBuildProject(project).then(userCanBuildProject -> {
            Assert.assertTrue((boolean)userCanBuildProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanNotBuildProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.BUILD, this.user)).thenReturn((Object)false);
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, false, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canBuildProject(project).then(userCanBuildProject -> {
            Assert.assertFalse((boolean)userCanBuildProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanBuildProjectTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, true, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canBuildProject(project).then(userCanBuildProject -> {
            Assert.assertTrue((boolean)userCanBuildProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanNotBuildProjectTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, false, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canBuildProject(project).then(userCanBuildProject -> {
            Assert.assertFalse((boolean)userCanBuildProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanDeployProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.BUILD, this.user)).thenReturn((Object)true);
        this.projectController.canDeployProject(project).then(userCanDeployProject -> {
            Assert.assertTrue((boolean)userCanDeployProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanNotDeployProjectTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.BUILD, this.user)).thenReturn((Object)false);
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, true, true, false)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canDeployProject(project).then(userCanDeployProject -> {
            Assert.assertFalse((boolean)userCanDeployProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanDeployProjectTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, true, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canDeployProject(project).then(userCanDeployProject -> {
            Assert.assertTrue((boolean)userCanDeployProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanNotDeployProjectTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, true, true, false)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canDeployProject(project).then(userCanDeployProject -> {
            Assert.assertFalse((boolean)userCanDeployProject);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanReadBranchTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), RepositoryAction.READ, this.user)).thenReturn((Object)true);
        this.projectController.canReadBranch(project).then(userCanReadBranch -> {
            Assert.assertTrue((boolean)userCanReadBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanNotReadBranchTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), RepositoryAction.READ, this.user)).thenReturn((Object)false);
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).checkBranchPermission((WorkspaceProject)ArgumentMatchers.eq((Object)project), (String)ArgumentMatchers.eq((Object)"branch"), (Function)ArgumentMatchers.any());
        this.projectController.canReadBranch(project).then(userCanReadBranch -> {
            Assert.assertFalse((boolean)userCanReadBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanReadBranchTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, true, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canDeleteBranch(project).then(userCanDeleteBranch -> {
            Assert.assertTrue((boolean)userCanDeleteBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanNotReadBranchTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", false, true, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canReadBranch(project).then(userCanReadBranch -> {
            Assert.assertFalse((boolean)userCanReadBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanDeleteBranchTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.DELETE, this.user)).thenReturn((Object)true);
        this.projectController.canDeleteBranch(project).then(userCanDeleteBranch -> {
            Assert.assertTrue((boolean)userCanDeleteBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanNotDeleteBranchTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.DELETE, this.user)).thenReturn((Object)false);
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).checkBranchPermission((WorkspaceProject)ArgumentMatchers.eq((Object)project), (String)ArgumentMatchers.eq((Object)"branch"), (Function)ArgumentMatchers.any());
        this.projectController.canDeleteBranch(project).then(userCanDeleteBranch -> {
            Assert.assertFalse((boolean)userCanDeleteBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanSubmitChangeRequestTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)).thenReturn((Object)true);
        this.projectController.canSubmitChangeRequest(project).then(userCanSubmitChangeRequest -> {
            Assert.assertTrue((boolean)userCanSubmitChangeRequest);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCannotSubmitChangeRequestTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)).thenReturn((Object)false);
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).checkBranchPermission((WorkspaceProject)ArgumentMatchers.eq((Object)project), (String)ArgumentMatchers.eq((Object)"branch"), (Function)ArgumentMatchers.any());
        this.projectController.canSubmitChangeRequest(project).then(userCanSubmitChangeRequest -> {
            Assert.assertFalse((boolean)userCanSubmitChangeRequest);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCannotSubmitChangeRequestWhenInDefaultBranchTest() {
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        Branch defaultBranch = (Branch)Mockito.mock(Branch.class);
        ((Branch)Mockito.doReturn((Object)"master").when((Object)defaultBranch)).getName();
        ((WorkspaceProject)Mockito.doReturn((Object)defaultBranch).when((Object)project)).getBranch();
        this.projectController.canSubmitChangeRequest(project).then(userCanSubmitChangeRequest -> {
            Assert.assertFalse((boolean)userCanSubmitChangeRequest);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanDeleteBranchTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, true, true, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canDeleteBranch(project).then(userCanDeleteBranch -> {
            Assert.assertTrue((boolean)userCanDeleteBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanNotDeleteBranchTest() {
        WorkspaceProject project = this.getProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve(Optional.of(new RolePermissions("CONTRIBUTOR", true, true, false, true)))).when((Object)this.projectController)).getBranchPermissionsForUser(project, "branch");
        this.projectController.canDeleteBranch(project).then(userCanDeleteBranch -> {
            Assert.assertFalse((boolean)userCanDeleteBranch);
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanUpdateAllBranchesTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)).thenReturn((Object)true);
        this.projectController.getUpdatableBranches(project).then(branches -> {
            Assert.assertEquals((long)2L, (long)branches.size());
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanReadAllBranchesTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), RepositoryAction.READ, this.user)).thenReturn((Object)true);
        this.projectController.getReadableBranches(project).then(branches -> {
            Assert.assertEquals((long)2L, (long)branches.size());
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void getReadableBranchesWhenInvalidModuleTest() {
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        this.projectController.getReadableBranches(project).then(branches -> {
            Assert.assertEquals((long)0L, (long)branches.size());
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void userCanNotUpdateAllBranchesTest() {
        WorkspaceProject project = this.getProject();
        Mockito.when((Object)this.authorizationManager.authorize((Resource)project.getRepository(), (ResourceAction)RepositoryAction.UPDATE, this.user)).thenReturn((Object)false);
        HashMap<String, RolePermissions> branch1PermissionsByRole = new HashMap<String, RolePermissions>();
        branch1PermissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", true, false, true, true));
        HashMap<String, RolePermissions> branch2PermissionsByRole = new HashMap<String, RolePermissions>();
        branch2PermissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", true, false, true, true));
        HashMap<String, BranchPermissions> branchPermissions = new HashMap<String, BranchPermissions>();
        branchPermissions.put("branch", new BranchPermissions("branch", branch1PermissionsByRole));
        branchPermissions.put("branch2", new BranchPermissions("branch2", branch2PermissionsByRole));
        ((ProjectController)Mockito.doReturn(Optional.of(new Contributor("contributor", ContributorType.CONTRIBUTOR))).when((Object)this.projectController)).getUserContributor((Collection)ArgumentMatchers.any());
        ((ProjectPermissionsService)Mockito.doReturn(branchPermissions).when((Object)this.projectPermissionsService)).loadBranchPermissions((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), Mockito.anyList());
        this.projectController.getUpdatableBranches(project).then(branches -> {
            Assert.assertEquals((long)0L, (long)branches.size());
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanUpdateSomeBranchesTest() {
        WorkspaceProject project = this.getProject();
        HashMap<String, RolePermissions> branch1PermissionsByRole = new HashMap<String, RolePermissions>();
        branch1PermissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", true, false, true, true));
        HashMap<String, RolePermissions> branch2PermissionsByRole = new HashMap<String, RolePermissions>();
        branch2PermissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", true, true, true, true));
        HashMap<String, BranchPermissions> branchPermissions = new HashMap<String, BranchPermissions>();
        branchPermissions.put("branch", new BranchPermissions("branch", branch1PermissionsByRole));
        branchPermissions.put("branch2", new BranchPermissions("branch2", branch2PermissionsByRole));
        ((ProjectController)Mockito.doReturn(Optional.of(new Contributor("contributor", ContributorType.CONTRIBUTOR))).when((Object)this.projectController)).getUserContributor((Collection)ArgumentMatchers.any());
        ((ProjectPermissionsService)Mockito.doReturn(branchPermissions).when((Object)this.projectPermissionsService)).loadBranchPermissions((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), Mockito.anyList());
        this.projectController.getUpdatableBranches(project).then(branches -> {
            Assert.assertEquals((long)1L, (long)branches.size());
            Assert.assertEquals((Object)"branch2", (Object)((Branch)branches.get(0)).getName());
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanReadAllBranchesTest() {
        WorkspaceProject project = this.getProject();
        HashMap<String, RolePermissions> branch1PermissionsByRole = new HashMap<String, RolePermissions>();
        branch1PermissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", true, false, false, false));
        HashMap<String, RolePermissions> branch2PermissionsByRole = new HashMap<String, RolePermissions>();
        branch2PermissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", true, false, false, false));
        HashMap<String, BranchPermissions> branchPermissions = new HashMap<String, BranchPermissions>();
        branchPermissions.put("branch", new BranchPermissions("branch", branch1PermissionsByRole));
        branchPermissions.put("branch2", new BranchPermissions("branch2", branch2PermissionsByRole));
        ((ProjectController)Mockito.doReturn(Optional.of(new Contributor("contributor", ContributorType.CONTRIBUTOR))).when((Object)this.projectController)).getUserContributor((Collection)ArgumentMatchers.any());
        ((ProjectPermissionsService)Mockito.doReturn(branchPermissions).when((Object)this.projectPermissionsService)).loadBranchPermissions((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), Mockito.anyList());
        this.projectController.getReadableBranches(project).then(branches -> {
            Assert.assertEquals((long)2L, (long)branches.size());
            Assert.assertEquals((Object)"branch", (Object)((Branch)branches.get(0)).getName());
            Assert.assertEquals((Object)"branch2", (Object)((Branch)branches.get(1)).getName());
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCanReadSomeBranchesTest() {
        WorkspaceProject project = this.getProject();
        HashMap<String, RolePermissions> branch1PermissionsByRole = new HashMap<String, RolePermissions>();
        branch1PermissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", false, false, false, false));
        HashMap<String, RolePermissions> branch2PermissionsByRole = new HashMap<String, RolePermissions>();
        branch2PermissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", true, false, false, false));
        HashMap<String, BranchPermissions> branchPermissions = new HashMap<String, BranchPermissions>();
        branchPermissions.put("branch", new BranchPermissions("branch", branch1PermissionsByRole));
        branchPermissions.put("branch2", new BranchPermissions("branch2", branch2PermissionsByRole));
        ((ProjectController)Mockito.doReturn(Optional.of(new Contributor("contributor", ContributorType.CONTRIBUTOR))).when((Object)this.projectController)).getUserContributor((Collection)ArgumentMatchers.any());
        ((ProjectPermissionsService)Mockito.doReturn(branchPermissions).when((Object)this.projectPermissionsService)).loadBranchPermissions((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), Mockito.anyList());
        this.projectController.getReadableBranches(project).then(branches -> {
            Assert.assertEquals((long)1L, (long)branches.size());
            Assert.assertEquals((Object)"branch2", (Object)((Branch)branches.get(0)).getName());
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    @Test
    public void projectContributorCannotReadBranchesTest() {
        WorkspaceProject project = this.getProject();
        HashMap<String, RolePermissions> branch1PermissionsByRole = new HashMap<String, RolePermissions>();
        branch1PermissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", false, false, false, false));
        HashMap<String, RolePermissions> branch2PermissionsByRole = new HashMap<String, RolePermissions>();
        branch2PermissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", false, false, false, false));
        HashMap<String, BranchPermissions> branchPermissions = new HashMap<String, BranchPermissions>();
        branchPermissions.put("branch", new BranchPermissions("branch", branch1PermissionsByRole));
        branchPermissions.put("branch2", new BranchPermissions("branch2", branch2PermissionsByRole));
        ((ProjectController)Mockito.doReturn(Optional.of(new Contributor("contributor", ContributorType.CONTRIBUTOR))).when((Object)this.projectController)).getUserContributor((Collection)ArgumentMatchers.any());
        ((ProjectPermissionsService)Mockito.doReturn(branchPermissions).when((Object)this.projectPermissionsService)).loadBranchPermissions((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), Mockito.anyList());
        this.projectController.getReadableBranches(project).then(branches -> {
            Assert.assertEquals((long)0L, (long)branches.size());
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.fail();
            return this.promises.resolve();
        });
    }

    private WorkspaceProject getProject() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        ArrayList projectContributors = new ArrayList();
        ((Repository)Mockito.doReturn(projectContributors).when((Object)repository)).getContributors();
        OrganizationalUnit organizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ArrayList organizationalUnitContributors = new ArrayList();
        ((OrganizationalUnit)Mockito.doReturn(organizationalUnitContributors).when((Object)organizationalUnit)).getContributors();
        Space space = (Space)Mockito.mock(Space.class);
        Branch branch = (Branch)Mockito.mock(Branch.class);
        ((Branch)Mockito.doReturn((Object)"branch").when((Object)branch)).getName();
        Branch branch2 = (Branch)Mockito.mock(Branch.class);
        ((Branch)Mockito.doReturn((Object)"branch2").when((Object)branch2)).getName();
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        ((WorkspaceProject)Mockito.doReturn((Object)repository).when((Object)project)).getRepository();
        ((WorkspaceProject)Mockito.doReturn((Object)organizationalUnit).when((Object)project)).getOrganizationalUnit();
        ((WorkspaceProject)Mockito.doReturn((Object)space).when((Object)project)).getSpace();
        ((WorkspaceProject)Mockito.doReturn((Object)branch).when((Object)project)).getBranch();
        ((Repository)Mockito.doReturn(Optional.of(branch2)).when((Object)repository)).getBranch("branch2");
        ((Repository)Mockito.doReturn(Arrays.asList(branch, branch2)).when((Object)repository)).getBranches();
        ((WorkspaceProject)Mockito.doReturn((Object)Mockito.mock(Module.class)).when((Object)project)).getMainModule();
        return project;
    }
}

