/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.plugin.model.CodeType;
import org.uberfire.ext.plugin.model.Framework;
import org.uberfire.ext.plugin.model.Language;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;

@Portable
public class PluginSimpleContent
extends Plugin {
    private String template;
    private String css;
    private Map<CodeType, String> codeMap;
    private Set<Framework> frameworks = new HashSet<Framework>();
    private Language language;

    public PluginSimpleContent() {
    }

    public PluginSimpleContent(String name, PluginType type, Path path, String template, String css, Map<CodeType, String> codeMap, Set<Framework> frameworks, Language language) {
        super(name, type, path);
        this.template = template;
        this.css = css;
        this.codeMap = codeMap;
        this.frameworks = frameworks;
        this.language = language;
    }

    public PluginSimpleContent(PluginSimpleContent pluginContent, String template, String css, Map<CodeType, String> codeMap, Collection<Framework> frameworks, Language language) {
        super(pluginContent.getName(), pluginContent.getType(), pluginContent.getPath());
        this.codeMap = new HashMap<CodeType, String>(pluginContent.getCodeMap() != null ? pluginContent.getCodeMap() : Collections.emptyMap());
        if (codeMap != null && !codeMap.isEmpty()) {
            for (Map.Entry<CodeType, String> codeTypeStringEntry : codeMap.entrySet()) {
                this.codeMap.put(codeTypeStringEntry.getKey(), codeTypeStringEntry.getValue());
            }
        }
        if (frameworks != null) {
            this.frameworks.clear();
            this.frameworks.addAll(frameworks);
        }
        this.language = pluginContent.getLanguage();
        if (language != null) {
            this.language = language;
        }
        this.template = pluginContent.getTemplate();
        if (template != null) {
            this.template = template;
        }
        this.css = pluginContent.getCss();
        if (css != null) {
            this.css = css;
        }
    }

    public PluginSimpleContent(PluginSimpleContent pluginContent, String template, Map<CodeType, String> codeMap) {
        super(pluginContent.getName(), pluginContent.getType(), pluginContent.getPath());
        this.codeMap = new HashMap<CodeType, String>(pluginContent.getCodeMap() != null ? pluginContent.getCodeMap() : Collections.emptyMap());
        if (codeMap != null && !codeMap.isEmpty()) {
            for (Map.Entry<CodeType, String> codeTypeStringEntry : codeMap.entrySet()) {
                this.codeMap.put(codeTypeStringEntry.getKey(), codeTypeStringEntry.getValue());
            }
        }
        this.template = pluginContent.getTemplate();
        if (template != null) {
            this.template = template;
        }
        this.css = pluginContent.getCss();
        this.frameworks = new HashSet(pluginContent.getFrameworks() != null ? pluginContent.getFrameworks() : Collections.emptyList());
        this.language = pluginContent.getLanguage();
    }

    public String getTemplate() {
        return this.template;
    }

    public String getCss() {
        return this.css;
    }

    public Map<CodeType, String> getCodeMap() {
        return this.codeMap;
    }

    public Collection<Framework> getFrameworks() {
        return this.frameworks;
    }

    public Language getLanguage() {
        return this.language;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginSimpleContent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PluginSimpleContent that = (PluginSimpleContent)o;
        if (this.codeMap != null ? !this.codeMap.equals(that.codeMap) : that.codeMap != null) {
            return false;
        }
        if (this.css != null ? !this.css.equals(that.css) : that.css != null) {
            return false;
        }
        if (this.frameworks != null ? !this.frameworks.equals(that.frameworks) : that.frameworks != null) {
            return false;
        }
        if (this.language != that.language) {
            return false;
        }
        return !(this.template != null ? !this.template.equals(that.template) : that.template != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = ~(~result);
        result = 31 * result + (this.template != null ? this.template.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.css != null ? this.css.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.codeMap != null ? this.codeMap.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.frameworks != null ? this.frameworks.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

