/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.navigator;

import com.github.gwtbootstrap.client.ui.Collapse;
import com.github.gwtbootstrap.client.ui.CollapseTrigger;
import com.github.gwtbootstrap.client.ui.Divider;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.NavList;
import com.github.gwtbootstrap.client.ui.WellNavList;
import com.github.gwtbootstrap.client.ui.base.ListItem;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.uberfire.client.editor.JSEditorActivity;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.client.perspective.JSWorkbenchPerspectiveActivity;
import org.uberfire.client.screen.JSWorkbenchScreenActivity;
import org.uberfire.client.splash.JSSplashScreenActivity;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.ClientTypeRegistry;
import org.uberfire.ext.plugin.client.type.DynamicMenuResourceType;
import org.uberfire.ext.plugin.client.type.EditorPluginResourceType;
import org.uberfire.ext.plugin.client.type.PerspectiveLayoutPluginResourceType;
import org.uberfire.ext.plugin.client.type.ScreenPluginResourceType;
import org.uberfire.ext.plugin.client.type.SplashPluginResourceType;
import org.uberfire.ext.plugin.client.widget.navigator.TriggerWidget;
import org.uberfire.ext.plugin.event.BaseNewPlugin;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.type.TypeConverterUtil;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@Dependent
public class PluginNavList
extends Composite {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private static final Comparator<String> PLUGIN_NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };
    @UiField
    WellNavList pluginsList;
    @Inject
    private ClientTypeRegistry clientTypeRegistry;
    @Inject
    private EditorPluginResourceType editorPluginResourceType;
    @Inject
    private PerspectiveLayoutPluginResourceType perspectiveLayoutPluginResourceType;
    @Inject
    private ScreenPluginResourceType screenPluginResourceType;
    @Inject
    private SplashPluginResourceType splashPluginResourceType;
    @Inject
    private DynamicMenuResourceType dynamicMenuResourceType;
    @Inject
    private ActivityManager activityManager;
    @Inject
    private PlaceManager placeManager;
    private Map<String, Widget> pluginRef = new HashMap<String, Widget>();
    private final Map<PluginType, NavList> navLists = new HashMap<PluginType, NavList>();

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void setup(Collection<Plugin> plugins) {
        LinkedHashMap classified = new LinkedHashMap();
        classified.put(this.perspectiveLayoutPluginResourceType, new HashSet());
        classified.put(this.screenPluginResourceType, new HashSet());
        classified.put(this.editorPluginResourceType, new HashSet());
        classified.put(this.splashPluginResourceType, new HashSet());
        classified.put(this.dynamicMenuResourceType, new HashSet());
        Collection screens = IOC.getBeanManager().lookupBeans(WorkbenchScreenActivity.class);
        for (IOCBeanDef beanDef : screens) {
            ((Set)classified.get((Object)this.screenPluginResourceType)).add(new Activity(this.getName(beanDef), PluginType.SCREEN));
        }
        Collection perspectives = IOC.getBeanManager().lookupBeans(PerspectiveActivity.class);
        for (IOCBeanDef beanDef : perspectives) {
            ((Set)classified.get((Object)this.perspectiveLayoutPluginResourceType)).add(new Activity(this.getName(beanDef), PluginType.PERSPECTIVE));
        }
        Collection editors = IOC.getBeanManager().lookupBeans(WorkbenchEditorActivity.class);
        for (IOCBeanDef beanDef : editors) {
            ((Set)classified.get((Object)this.editorPluginResourceType)).add(new Activity(this.getName(beanDef), PluginType.EDITOR));
        }
        Collection splashes = IOC.getBeanManager().lookupBeans(SplashScreenActivity.class);
        for (IOCBeanDef beanDef : splashes) {
            ((Set)classified.get((Object)this.splashPluginResourceType)).add(new Activity(this.getName(beanDef), PluginType.SPLASH));
        }
        for (Plugin plugin : plugins) {
            ClientResourceType type = this.clientTypeRegistry.resolve(plugin.getPath());
            if (type == null) continue;
            ((Set)classified.get(type)).add(plugin);
        }
        Collection jsscreens = IOC.getBeanManager().lookupBeans(JSWorkbenchScreenActivity.class);
        for (IOCBeanDef beanDef : jsscreens) {
            ((Set)classified.get((Object)this.screenPluginResourceType)).add(new Activity(beanDef.getName(), PluginType.SCREEN));
        }
        Collection jsperspectives = IOC.getBeanManager().lookupBeans(JSWorkbenchPerspectiveActivity.class);
        for (IOCBeanDef beanDef : jsperspectives) {
            ((Set)classified.get((Object)this.perspectiveLayoutPluginResourceType)).add(new Activity(beanDef.getName(), PluginType.PERSPECTIVE));
        }
        Collection jseditors = IOC.getBeanManager().lookupBeans(JSEditorActivity.class);
        for (IOCBeanDef beanDef : jseditors) {
            ((Set)classified.get((Object)this.editorPluginResourceType)).add(new Activity(beanDef.getName(), PluginType.EDITOR));
        }
        Collection jssplashes = IOC.getBeanManager().lookupBeans(JSSplashScreenActivity.class);
        for (IOCBeanDef beanDef : jssplashes) {
            ((Set)classified.get((Object)this.splashPluginResourceType)).add(new Activity(beanDef.getName(), PluginType.SPLASH));
        }
        this.pluginsList.clear();
        Iterator itr = classified.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            PluginType type = TypeConverterUtil.fromResourceType((ResourceTypeDefinition)((ResourceTypeDefinition)e.getKey()));
            CollapseTrigger collapseTrigger = this.makeTriggerWidget((ClientResourceType)e.getKey(), type);
            Collapse collapse = new Collapse();
            collapse.setExistTrigger(true);
            collapse.setId(type.toString());
            NavList itemsNavList = new NavList();
            collapse.add((Widget)itemsNavList);
            this.navLists.put(type, itemsNavList);
            TreeMap<String, Activity> activities = new TreeMap<String, Activity>(PLUGIN_NAME_COMPARATOR);
            for (Activity item : (Set)e.getValue()) {
                if (this.thereIsAlreadyAPluginWithSameName(item, activities)) continue;
                activities.put(item.getName(), item);
            }
            for (Activity item : activities.values()) {
                itemsNavList.add(this.makeItemNavLink(item));
            }
            collapse.setDefaultOpen(false);
            this.pluginsList.add((IsWidget)collapseTrigger);
            this.pluginsList.add((IsWidget)collapse);
            if (!itr.hasNext()) continue;
            this.pluginsList.add((Widget)new Divider());
        }
    }

    private boolean thereIsAlreadyAPluginWithSameName(Activity item, Map<String, Activity> activities) {
        Activity activity = activities.get(item.getName());
        return activity != null && activity instanceof Plugin;
    }

    private String getName(IOCBeanDef<?> beanDef) {
        for (Annotation annotation : beanDef.getQualifiers()) {
            if (!(annotation instanceof Named)) continue;
            return ((Named)annotation).value();
        }
        return "";
    }

    private CollapseTrigger makeTriggerWidget(final ClientResourceType resourceType, PluginType type) {
        return new CollapseTrigger("#" + type.toString()){
            {
                super(x0);
                if (resourceType.getIcon() == null) {
                    this.setWidget((Widget)new TriggerWidget(resourceType.getDescription()));
                } else {
                    this.setWidget((Widget)new TriggerWidget(resourceType.getIcon(), resourceType.getDescription()));
                }
            }
        };
    }

    private Widget makeItemNavLink(final Activity activity) {
        Object nav = activity instanceof Plugin ? new NavLink(activity.getName()){
            {
                super(x0);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        PluginNavList.this.placeManager.goTo(new PathPlaceRequest(((Plugin)activity).getPath()).addParameter("name", activity.getName()));
                    }
                });
            }
        } : new ListItem(new Widget[]{new InlineLabel(activity.getName())});
        this.pluginRef.put(activity.getName(), (Widget)nav);
        return this.pluginRef.get(activity.getName());
    }

    public void onPlugInAdded(@Observes PluginAdded pluginAdded) {
        this.addNewPlugin((BaseNewPlugin)pluginAdded);
    }

    public void addNewPlugin(BaseNewPlugin newPlugin) {
        TreeMap<String, Widget> sortedNavList = new TreeMap<String, Widget>(PLUGIN_NAME_COMPARATOR);
        NavList navList = this.navLists.get(newPlugin.getPlugin().getType());
        for (int i = 0; i < navList.getWidgetCount(); ++i) {
            Widget w = navList.getWidget(i);
            for (Map.Entry<String, Widget> e : this.pluginRef.entrySet()) {
                if (!e.getValue().equals(w)) continue;
                sortedNavList.put(e.getKey(), e.getValue());
            }
        }
        sortedNavList.put(newPlugin.getPlugin().getName(), this.makeItemNavLink((Activity)newPlugin.getPlugin()));
        navList.clear();
        for (Widget w : sortedNavList.values()) {
            navList.add(w);
        }
    }

    public void onPlugInRenamed(@Observes PluginRenamed pluginRenamed) {
        Widget nav = this.pluginRef.get(pluginRenamed.getOldPluginName());
        if (nav != null) {
            nav.removeFromParent();
        }
        this.addNewPlugin((BaseNewPlugin)pluginRenamed);
    }

    public void onPlugInDeleted(@Observes PluginDeleted pluginDeleted) {
        Widget nav = this.pluginRef.get(pluginDeleted.getPluginName());
        if (nav != null) {
            nav.removeFromParent();
        }
    }

    static interface ViewBinder
    extends UiBinder<Widget, PluginNavList> {
    }
}

