/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.popup;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.plugin.exception.PluginAlreadyExists;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;
import org.uberfire.mvp.impl.PathPlaceRequest;

@ApplicationScoped
public class NewPluginPopUp
extends BaseModal {
    private PluginType type;
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private final Command okCommand = new Command(){

        public void execute() {
            NewPluginPopUp.this.onOKButtonClick();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            NewPluginPopUp.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);
    @UiField
    TextBox name;
    @UiField
    HelpInline nameHelpInline;
    @UiField
    ControlGroup nameGroup;
    @Inject
    private Caller<PluginServices> pluginServices;
    @Inject
    private PlaceManager placeManager;

    @PostConstruct
    public void init() {
        this.footer.enableOkButton(true);
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
    }

    public void show(PluginType type) {
        this.type = (PluginType)PortablePreconditions.checkNotNull((String)"type", (Object)type);
        this.name.setText("");
        this.nameHelpInline.setText("");
        this.nameGroup.setType(ControlGroupType.NONE);
        switch (this.type) {
            case PERSPECTIVE: {
                this.setTitle("New Perspective Plugin...");
                break;
            }
            case PERSPECTIVE_LAYOUT: {
                this.setTitle("New Perspective Layout Plugin...");
                break;
            }
            case SCREEN: {
                this.setTitle("New Screen Plugin...");
                break;
            }
            case EDITOR: {
                this.setTitle("New Editor Plugin...");
                break;
            }
            case SPLASH: {
                this.setTitle("New Splash Plugin...");
                break;
            }
            case DYNAMIC_MENU: {
                this.setTitle("New Dynamic Menu...");
            }
        }
        super.show();
    }

    private void onOKButtonClick() {
        if (this.name.getText().trim().isEmpty()) {
            this.nameHelpInline.setText("Name is mandatory.");
            this.nameGroup.setType(ControlGroupType.ERROR);
            return;
        }
        ((PluginServices)this.pluginServices.call((RemoteCallback)new RemoteCallback<Plugin>(){

            public void callback(Plugin response) {
                NewPluginPopUp.this.placeManager.goTo(new PathPlaceRequest(response.getPath()).addParameter("name", response.getName()));
                NewPluginPopUp.this.hide();
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object message, Throwable throwable) {
                NewPluginPopUp.this.nameGroup.setType(ControlGroupType.ERROR);
                if (throwable instanceof PluginAlreadyExists) {
                    NewPluginPopUp.this.nameHelpInline.setText("Plugin name already exists.");
                } else {
                    NewPluginPopUp.this.nameHelpInline.setText("Invalid plugin name.");
                }
                return false;
            }
        })).createNewPlugin(this.name.getText(), this.type);
    }

    static interface ViewBinder
    extends UiBinder<Widget, NewPluginPopUp> {
    }
}

