/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.split;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.plugin.client.widget.split.Splitter;
import org.uberfire.mvp.Command;

public class HorizontalSplit
extends Splitter {
    private double offset;
    private Widget topArea;
    private Widget bottomArea;
    private Widget contentArea;
    private Command onResize;

    public HorizontalSplit() {
        this.addDomHandler((EventHandler)new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (HorizontalSplit.this.mouseDown) {
                    double topHeightPct = ((double)(event.getClientY() - HorizontalSplit.this.getContentAbsoluteTop()) - HorizontalSplit.this.offset) / (double)HorizontalSplit.this.getContentHeight() * 100.0;
                    double bottomHeightPct = 100.0 - topHeightPct;
                    HorizontalSplit.this.setTopAreaHeight(topHeightPct);
                    HorizontalSplit.this.setBottomHeight(bottomHeightPct);
                    HorizontalSplit.this.getElement().getStyle().setTop((double)(HorizontalSplit.this.topArea.getOffsetHeight() - 6), Style.Unit.PX);
                    HorizontalSplit.this.onResize.execute();
                    event.preventDefault();
                }
            }
        }, MouseMoveEvent.getType());
    }

    @Override
    protected void buildOffset(MouseDownEvent event) {
        this.offset = event.getClientY() - this.getAbsoluteTop();
    }

    public void init(Widget topArea, Widget bottomArea, Widget contentArea, Command onResize) {
        this.topArea = topArea;
        this.bottomArea = bottomArea;
        this.contentArea = contentArea;
        this.onResize = onResize;
    }

    private void setBottomHeight(double height) {
        this.bottomArea.setHeight(height + "%");
    }

    private void setTopAreaHeight(double height) {
        this.topArea.setHeight(height + "%");
    }

    private int getContentHeight() {
        return this.contentArea.getOffsetHeight();
    }

    private int getContentAbsoluteTop() {
        return this.contentArea.getAbsoluteTop();
    }
}

