/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.validation;

import java.util.HashSet;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.plugin.client.info.PluginsInfo;
import org.uberfire.ext.plugin.client.validation.PluginNameValidator;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class PluginNameValidatorTest {
    @Mock
    private PluginsInfo pluginsInfo;
    @Mock
    private ValidatorWithReasonCallback callback;
    @Mock
    private PluginServices pluginServices;
    private Caller<PluginServices> pluginServicesCaller;
    @InjectMocks
    private PluginNameValidator validator;

    @Before
    public void setup() {
        this.pluginServicesCaller = new CallerMock((Object)this.pluginServices);
        this.validator.pluginServices = this.pluginServicesCaller;
        HashSet<Plugin> activities = new HashSet<Plugin>();
        activities.add(new Plugin("existingPerspectiveLayout", PluginType.PERSPECTIVE_LAYOUT, PathFactory.newPath((String)"test1", (String)"/tmp/test1")));
        activities.add(new Plugin("existingScreen", PluginType.SCREEN, PathFactory.newPath((String)"test2", (String)"/tmp/test2")));
        activities.add(new Plugin("existingEditor", PluginType.EDITOR, PathFactory.newPath((String)"test3", (String)"/tmp/test3")));
        activities.add(new Plugin("existingSplashScreen", PluginType.SPLASH, PathFactory.newPath((String)"test4", (String)"/tmp/test4")));
        activities.add(new Plugin("existingDynamicMenu", PluginType.DYNAMIC_MENU, PathFactory.newPath((String)"test5", (String)"/tmp/test5")));
        Mockito.when((Object)this.pluginsInfo.getAllPlugins(Matchers.anyCollection())).thenReturn(activities);
    }

    @Test
    public void validateEmptyName() {
        this.validator.validateName("", this.callback);
        ((ValidatorWithReasonCallback)Mockito.verify((Object)this.callback)).onFailure(ValidationErrorReason.EMPTY_NAME.name());
        this.validator.validateName("notEmpty", this.callback);
        ((ValidatorWithReasonCallback)Mockito.verify((Object)this.callback)).onSuccess();
    }

    @Test
    public void validateInvalidName() {
        this.validator.validateName("invalid*", this.callback);
        ((ValidatorWithReasonCallback)Mockito.verify((Object)this.callback)).onFailure(ValidationErrorReason.INVALID_NAME.name());
        this.validator.validateName("valid", this.callback);
        ((ValidatorWithReasonCallback)Mockito.verify((Object)this.callback)).onSuccess();
    }

    @Test
    public void validateDuplicatedName() {
        this.validator.validateName("existingPerspectiveLayout", this.callback);
        ((ValidatorWithReasonCallback)Mockito.verify((Object)this.callback)).onFailure(ValidationErrorReason.DUPLICATED_NAME.name());
        this.validator.validateName("nonExistingPerspectiveLayout", this.callback);
        ((ValidatorWithReasonCallback)Mockito.verify((Object)this.callback)).onSuccess();
    }
}

