/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.components.popup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.uberfire.ext.plugin.client.perspective.editor.PerspectiveEditorPresenter;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.client.validation.NameValidator;
import org.uberfire.ext.plugin.type.TagsConverterUtil;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class AddTag
extends BaseModal {
    private final PerspectiveEditorPresenter perspectivePresenter;
    @UiField
    FormGroup tagControlGroup;
    @UiField
    TextBox tag;
    @UiField
    HelpBlock tagInline;
    @UiField
    HorizontalPanel tags;
    private List<String> tagsList = new ArrayList<String>();
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public AddTag(PerspectiveEditorPresenter perspectivePresenter) {
        this.perspectivePresenter = perspectivePresenter;
        this.setTitle(CommonConstants.INSTANCE.AddTag());
        this.add((Widget)new ModalBody(){
            {
                this.add((Widget)uiBinder.createAndBindUi((Object)AddTag.this));
            }
        });
        this.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                AddTag.this.okButton();
            }
        }, new Command(){

            public void execute() {
                AddTag.this.cancelButton();
            }
        }));
    }

    private void cancelButton() {
        this.tagsList.clear();
        this.closePopup();
    }

    private void closePopup() {
        this.hide();
        super.hide();
    }

    public void show() {
        this.loadTags();
        super.show();
    }

    private void loadTags() {
        String tagsString = this.perspectivePresenter.getLayoutProperty("LAYOUT_TAGS");
        this.tagsList = TagsConverterUtil.convertTagStringToTag((String)tagsString);
        this.generateTags();
    }

    private void generateTags() {
        this.tags.clear();
        for (String tag : this.tagsList) {
            this.tags.add((Widget)new Label(tag));
            this.tags.add((Widget)this.generateRemoveIcon(tag));
        }
    }

    private void okButton() {
        String tags = TagsConverterUtil.convertTagsToString(this.tagsList);
        this.perspectivePresenter.saveProperty("LAYOUT_TAGS", tags);
        this.hide();
    }

    @UiHandler(value={"addTag"})
    void addTag(ClickEvent event) {
        NameValidator validator = NameValidator.tagNameValidator();
        if (validator.isValid(this.tag.getText())) {
            this.tagsList.add(this.tag.getText());
            this.tags.add((Widget)new Label(this.tag.getText()));
            this.tags.add((Widget)this.generateRemoveIcon(this.tag.getText()));
            this.tag.setText("");
            this.tagControlGroup.setValidationState(ValidationState.NONE);
            this.tagInline.setText("");
        } else {
            this.tagControlGroup.setValidationState(ValidationState.ERROR);
            this.tagInline.setText(validator.getValidationError());
        }
    }

    private Icon generateRemoveIcon(final String value) {
        Icon icon = new Icon(IconType.REMOVE);
        icon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                AddTag.this.tagsList.remove(value);
                AddTag.this.generateTags();
            }
        }, ClickEvent.getType());
        icon.getElement().getStyle().setColor("rgb(153, 153, 153)");
        icon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        return icon;
    }

    static interface Binder
    extends UiBinder<Widget, AddTag> {
    }
}

