/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.uberfire.client.mvp.ActivityBeansInfo;
import org.uberfire.ext.layout.editor.client.components.ModalConfigurationContext;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.client.validation.NameValidator;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.ButtonPressed;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class EditScreen
extends BaseModal {
    public static String PROPERTY_EDITOR_KEY = "LayoutEditor";
    private final ModalConfigurationContext configContext;
    @UiField
    TextBox key;
    @UiField
    FormGroup paramKeyControlGroup;
    @UiField
    HelpBlock paramKeyInline;
    @UiField
    TextBox value;
    @UiField
    PropertyEditorWidget propertyEditor;
    private ButtonPressed buttonPressed = ButtonPressed.CLOSE;
    private Map<String, String> lastParametersSaved = new HashMap<String, String>();
    protected List<String> availableWorkbenchScreensIds = new ArrayList<String>();
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public EditScreen(ModalConfigurationContext configContext) {
        this.getScreensId();
        this.configContext = configContext;
        this.setTitle(CommonConstants.INSTANCE.EditComponent());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.propertyEditor.handle(this.generateEvent(this.generateScreenSettingsCategory()));
        this.saveOriginalState();
        this.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                EditScreen.this.okButton();
            }
        }, new Command(){

            public void execute() {
                EditScreen.this.cancelButton();
            }
        }));
        this.addHiddenHandler();
    }

    protected void getScreensId() {
        ActivityBeansInfo activityBeansInfo = this.getActivityBeansInfo();
        this.availableWorkbenchScreensIds = activityBeansInfo.getAvailableWorkbenchScreensIds();
    }

    private void saveOriginalState() {
        this.lastParametersSaved = new HashMap<String, String>();
        Map layoutComponentProperties = this.configContext.getComponentProperties();
        for (String key : layoutComponentProperties.keySet()) {
            this.lastParametersSaved.put(key, (String)layoutComponentProperties.get(key));
        }
    }

    protected void addHiddenHandler() {
        this.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (EditScreen.this.userPressedCloseOrCancel()) {
                    EditScreen.this.revertChanges();
                    EditScreen.this.configContext.configurationCancelled();
                }
            }
        });
    }

    private boolean userPressedCloseOrCancel() {
        return ButtonPressed.CANCEL.equals((Object)this.buttonPressed) || ButtonPressed.CLOSE.equals((Object)this.buttonPressed);
    }

    private void revertChanges() {
        this.configContext.resetComponentProperties();
        for (String key : this.lastParametersSaved.keySet()) {
            this.configContext.setComponentProperty(key, this.lastParametersSaved.get(key));
        }
    }

    public void show() {
        super.show();
    }

    void okButton() {
        this.buttonPressed = ButtonPressed.OK;
        if (this.configContext.getComponentProperty("Place Name") == null) {
            if (!this.availableWorkbenchScreensIds.isEmpty()) {
                this.configContext.setComponentProperty("Place Name", this.availableWorkbenchScreensIds.get(0));
                this.configContext.configurationFinished();
            } else {
                this.configContext.configurationCancelled();
            }
        } else {
            this.configContext.configurationFinished();
        }
        this.hide();
    }

    void cancelButton() {
        this.buttonPressed = ButtonPressed.CANCEL;
        this.hide();
    }

    public void hide() {
        super.hide();
    }

    @UiHandler(value={"add"})
    void add(ClickEvent event) {
        PropertyEditorCategory property = this.addProperty();
        if (property == null) {
            return;
        }
        this.propertyEditor.handle(this.generateEvent(property));
        this.key.setText("");
        this.value.setText("");
    }

    private PropertyEditorCategory addProperty() {
        this.paramKeyInline.setText("");
        this.paramKeyControlGroup.setValidationState(ValidationState.NONE);
        NameValidator validator = NameValidator.parameterNameValidator();
        if (!validator.isValid(this.key.getText())) {
            this.paramKeyControlGroup.setValidationState(ValidationState.ERROR);
            this.paramKeyInline.setText(validator.getValidationError());
            return null;
        }
        Map properties = this.configContext.getComponentProperties();
        for (String parameterKey : properties.keySet()) {
            if (!this.key.getText().equals(parameterKey)) continue;
            this.paramKeyControlGroup.setValidationState(ValidationState.ERROR);
            this.paramKeyInline.setText(CommonConstants.INSTANCE.DuplicateParameterName());
            return null;
        }
        this.configContext.setComponentProperty(this.key.getText(), this.value.getText());
        return this.generateScreenSettingsCategory();
    }

    private PropertyEditorCategory generateScreenSettingsCategory() {
        PropertyEditorCategory category = new PropertyEditorCategory(CommonConstants.INSTANCE.ScreenConfiguration()){

            public List<PropertyEditorFieldInfo> getFields() {
                return new ArrayList<PropertyEditorFieldInfo>((Collection)super.getFields()){

                    @Override
                    public boolean remove(Object o) {
                        if (o instanceof PropertyEditorFieldInfo) {
                            PropertyEditorFieldInfo info = (PropertyEditorFieldInfo)o;
                            EditScreen.this.configContext.removeComponentProperty(info.getLabel());
                        }
                        return super.remove(o);
                    }
                };
            }
        };
        Map parameters = this.configContext.getComponentProperties();
        String selectedScreenId = (String)parameters.get("Place Name");
        category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.PlaceName(), selectedScreenId == null ? "" : selectedScreenId, PropertyEditorType.COMBO).withComboValues(this.availableWorkbenchScreensIds).withKey(this.configContext.hashCode() + "Place Name"));
        for (String key : parameters.keySet()) {
            if ("Place Name".equals(key)) continue;
            category.withField(new PropertyEditorFieldInfo(key, (String)parameters.get(key), PropertyEditorType.TEXT).withKey(this.configContext.hashCode() + key).withRemovalSupported(true));
        }
        this.propertyEditor.setLastOpenAccordionGroupTitle(category.getName());
        return category;
    }

    private ActivityBeansInfo getActivityBeansInfo() {
        IOCBeanDef activityBeansInfoIOCBeanDef = IOC.getBeanManager().lookupBean(ActivityBeansInfo.class, new Annotation[0]);
        return (ActivityBeansInfo)activityBeansInfoIOCBeanDef.getInstance();
    }

    private PropertyEditorEvent generateEvent(PropertyEditorCategory category) {
        PropertyEditorEvent event = new PropertyEditorEvent(PROPERTY_EDITOR_KEY, category);
        return event;
    }

    protected ModalConfigurationContext getConfigContext() {
        return this.configContext;
    }

    static interface Binder
    extends UiBinder<Widget, EditScreen> {
    }
}

