/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.navigator;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.LinkedGroup;
import org.gwtbootstrap3.client.ui.LinkedGroupItem;
import org.gwtbootstrap3.client.ui.ListGroupItem;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.PanelCollapse;
import org.gwtbootstrap3.client.ui.PanelGroup;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.plugin.client.info.PluginsInfo;
import org.uberfire.ext.plugin.event.BaseNewPlugin;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.type.TypeConverterUtil;
import org.uberfire.ext.widgets.common.client.accordion.TriggerWidget;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@Dependent
public class PluginNavList
extends Composite {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    private static final Comparator<String> PLUGIN_NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };
    @UiField
    PanelGroup pluginsList;
    @Inject
    private ActivityManager activityManager;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private PluginsInfo pluginsInfo;
    private Map<String, Widget> pluginRef = new HashMap<String, Widget>();
    private final Map<PluginType, LinkedGroup> listGroups = new HashMap<PluginType, LinkedGroup>();

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.pluginsList.setId(DOM.createUniqueId());
    }

    public void setup(Collection<Plugin> plugins) {
        Map<ClientResourceType, Set<Activity>> classified = this.pluginsInfo.getClassifiedPlugins(plugins);
        this.pluginsList.clear();
        for (final Map.Entry<ClientResourceType, Set<Activity>> entry : classified.entrySet()) {
            LinkedGroup itemsNavList = new LinkedGroup();
            PluginType type = TypeConverterUtil.fromResourceType((ResourceTypeDefinition)((ResourceTypeDefinition)entry.getKey()));
            final PanelCollapse collapse = new PanelCollapse();
            this.listGroups.put(type, itemsNavList);
            TreeMap<String, Activity> activities = new TreeMap<String, Activity>(PLUGIN_NAME_COMPARATOR);
            for (Activity item : entry.getValue()) {
                if (this.thereIsAlreadyAPluginWithSameName(item, activities)) continue;
                activities.put(item.getName(), item);
            }
            for (Activity item : activities.values()) {
                itemsNavList.add(this.makeItemNavLink(item));
            }
            PanelBody body = new PanelBody();
            body.add((Widget)itemsNavList);
            collapse.add((Widget)body);
            this.pluginsList.add((Widget)new Panel(){
                {
                    this.add((Widget)new TriggerWidget(((ClientResourceType)entry.getKey()).getIcon(), ((ClientResourceType)entry.getKey()).getDescription()){
                        {
                            this.setDataToggle(Toggle.COLLAPSE);
                            this.setDataParent(PluginNavList.this.pluginsList.getId());
                            this.setDataTargetWidget((Widget)collapse);
                        }
                    });
                    this.add((Widget)collapse);
                }
            });
        }
    }

    private boolean thereIsAlreadyAPluginWithSameName(Activity item, Map<String, Activity> activities) {
        Activity activity = activities.get(item.getName());
        return activity != null && activity instanceof Plugin;
    }

    private Widget makeItemNavLink(final Activity activity) {
        Object nav = activity instanceof Plugin ? new LinkedGroupItem(){
            {
                this.setText(activity.getName());
                this.getElement().getStyle().setProperty("textDecoration", "underline");
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        PluginNavList.this.placeManager.goTo(new PathPlaceRequest(((Plugin)activity).getPath()).addParameter("name", activity.getName()));
                    }
                });
            }
        } : new ListGroupItem(){
            {
                this.setText(activity.getName());
            }
        };
        this.pluginRef.put(activity.getName(), (Widget)nav);
        return this.pluginRef.get(activity.getName());
    }

    public void onPlugInAdded(@Observes PluginAdded pluginAdded) {
        this.addNewPlugin((BaseNewPlugin)pluginAdded);
    }

    public void addNewPlugin(BaseNewPlugin newPlugin) {
        TreeMap<String, Widget> sortedNavList = new TreeMap<String, Widget>(PLUGIN_NAME_COMPARATOR);
        LinkedGroup navList = this.listGroups.get(newPlugin.getPlugin().getType());
        for (int i = 0; i < navList.getWidgetCount(); ++i) {
            Widget w = navList.getWidget(i);
            for (Map.Entry<String, Widget> e : this.pluginRef.entrySet()) {
                if (!e.getValue().equals(w)) continue;
                sortedNavList.put(e.getKey(), e.getValue());
            }
        }
        sortedNavList.put(newPlugin.getPlugin().getName(), this.makeItemNavLink((Activity)newPlugin.getPlugin()));
        navList.clear();
        for (Widget w : sortedNavList.values()) {
            navList.add(w);
        }
    }

    public void onPlugInRenamed(@Observes PluginRenamed pluginRenamed) {
        Widget nav = this.pluginRef.get(pluginRenamed.getOldPluginName());
        if (nav != null) {
            nav.removeFromParent();
        }
        this.addNewPlugin((BaseNewPlugin)pluginRenamed);
    }

    public void onPlugInDeleted(@Observes PluginDeleted pluginDeleted) {
        Widget nav = this.pluginRef.get(pluginDeleted.getPluginName());
        if (nav != null) {
            nav.removeFromParent();
        }
    }

    static interface ViewBinder
    extends UiBinder<Widget, PluginNavList> {
    }
}

