/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.info;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.uberfire.client.editor.JSEditorActivity;
import org.uberfire.client.mvp.ActivityBeansInfo;
import org.uberfire.client.perspective.JSWorkbenchPerspectiveActivity;
import org.uberfire.client.screen.JSWorkbenchScreenActivity;
import org.uberfire.client.splash.JSSplashScreenActivity;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.ClientTypeRegistry;
import org.uberfire.ext.plugin.client.type.DynamicMenuResourceType;
import org.uberfire.ext.plugin.client.type.EditorPluginResourceType;
import org.uberfire.ext.plugin.client.type.PerspectiveLayoutPluginResourceType;
import org.uberfire.ext.plugin.client.type.ScreenPluginResourceType;
import org.uberfire.ext.plugin.client.type.SplashPluginResourceType;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;

@ApplicationScoped
public class PluginsInfo {
    private EditorPluginResourceType editorPluginResourceType;
    private PerspectiveLayoutPluginResourceType perspectiveLayoutPluginResourceType;
    private ScreenPluginResourceType screenPluginResourceType;
    private SplashPluginResourceType splashPluginResourceType;
    private DynamicMenuResourceType dynamicMenuResourceType;
    private ActivityBeansInfo activityBeansInfo;
    private ClientTypeRegistry clientTypeRegistry;

    public PluginsInfo() {
    }

    @Inject
    public PluginsInfo(EditorPluginResourceType editorPluginResourceType, PerspectiveLayoutPluginResourceType perspectiveLayoutPluginResourceType, ScreenPluginResourceType screenPluginResourceType, SplashPluginResourceType splashPluginResourceType, DynamicMenuResourceType dynamicMenuResourceType, ActivityBeansInfo activityBeansInfo, ClientTypeRegistry clientTypeRegistry) {
        this.editorPluginResourceType = editorPluginResourceType;
        this.perspectiveLayoutPluginResourceType = perspectiveLayoutPluginResourceType;
        this.screenPluginResourceType = screenPluginResourceType;
        this.splashPluginResourceType = splashPluginResourceType;
        this.dynamicMenuResourceType = dynamicMenuResourceType;
        this.activityBeansInfo = activityBeansInfo;
        this.clientTypeRegistry = clientTypeRegistry;
    }

    public Set<Activity> getAllPlugins(Collection<Plugin> plugins) {
        HashSet<Activity> activities = new HashSet<Activity>();
        Collection<Set<Activity>> groupedActivities = this.getClassifiedPlugins(plugins).values();
        for (Set<Activity> groupOfActivities : groupedActivities) {
            activities.addAll(groupOfActivities);
        }
        return activities;
    }

    public Map<ClientResourceType, Set<Activity>> getClassifiedPlugins(Collection<Plugin> plugins) {
        LinkedHashMap<ClientResourceType, Set<Activity>> classified = new LinkedHashMap<ClientResourceType, Set<Activity>>();
        classified.put(this.perspectiveLayoutPluginResourceType, new HashSet());
        classified.put(this.screenPluginResourceType, new HashSet());
        classified.put(this.editorPluginResourceType, new HashSet());
        classified.put(this.splashPluginResourceType, new HashSet());
        classified.put(this.dynamicMenuResourceType, new HashSet());
        for (String string : this.activityBeansInfo.getAvailableWorkbenchScreensIds()) {
            ((Set)classified.get((Object)this.screenPluginResourceType)).add(new Activity(string, PluginType.SCREEN));
        }
        for (String string : this.activityBeansInfo.getAvailablePerspectivesIds()) {
            ((Set)classified.get((Object)this.perspectiveLayoutPluginResourceType)).add(new Activity(string, PluginType.PERSPECTIVE));
        }
        for (String string : this.activityBeansInfo.getAvailableWorkbenchEditorsIds()) {
            ((Set)classified.get((Object)this.editorPluginResourceType)).add(new Activity(string, PluginType.EDITOR));
        }
        for (String string : this.activityBeansInfo.getAvailableSplashScreensIds()) {
            ((Set)classified.get((Object)this.splashPluginResourceType)).add(new Activity(string, PluginType.SPLASH));
        }
        for (Plugin plugin : plugins) {
            ClientResourceType clientResourceType = this.clientTypeRegistry.resolve(plugin.getPath());
            if (clientResourceType == null) continue;
            ((Set)classified.get(clientResourceType)).add(plugin);
        }
        Collection<SyncBeanDef<JSWorkbenchScreenActivity>> jsscreens = this.lookupBeans(JSWorkbenchScreenActivity.class);
        for (SyncBeanDef<JSWorkbenchScreenActivity> syncBeanDef : jsscreens) {
            ((Set)classified.get((Object)this.screenPluginResourceType)).add(new Activity(syncBeanDef.getName(), PluginType.SCREEN));
        }
        Collection<SyncBeanDef<JSWorkbenchPerspectiveActivity>> collection = this.lookupBeans(JSWorkbenchPerspectiveActivity.class);
        for (SyncBeanDef<JSWorkbenchPerspectiveActivity> syncBeanDef : collection) {
            ((Set)classified.get((Object)this.perspectiveLayoutPluginResourceType)).add(new Activity(syncBeanDef.getName(), PluginType.PERSPECTIVE));
        }
        Collection<SyncBeanDef<JSEditorActivity>> collection2 = this.lookupBeans(JSEditorActivity.class);
        for (SyncBeanDef<JSEditorActivity> syncBeanDef : collection2) {
            ((Set)classified.get((Object)this.editorPluginResourceType)).add(new Activity(syncBeanDef.getName(), PluginType.EDITOR));
        }
        Collection<SyncBeanDef<JSSplashScreenActivity>> collection3 = this.lookupBeans(JSSplashScreenActivity.class);
        for (SyncBeanDef<JSSplashScreenActivity> beanDef : collection3) {
            ((Set)classified.get((Object)this.splashPluginResourceType)).add(new Activity(beanDef.getName(), PluginType.SPLASH));
        }
        return classified;
    }

    <T> Collection<SyncBeanDef<T>> lookupBeans(Class<T> clazz) {
        return IOC.getBeanManager().lookupBeans(clazz);
    }
}

